/**
 *  ResultBaseEventHandler.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.result.module.core;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;

import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.result.MarkAreaAnswerItem;
import net.sqs2.omr.result.MarkAreaAnswer;
import net.sqs2.omr.result.TextAreaAnswer;
import net.sqs2.omr.result.event.QuestionEvent;
import net.sqs2.omr.result.event.ResultEventHandler;
import net.sqs2.omr.result.event.QuestionItemEvent;
import net.sqs2.omr.result.event.TableEventContext.MarkAreaAnswerItemsByColumn;
import net.sqs2.omr.result.event.TableEventContext.TextAreaAnswerListByColumn;

public class ContextGeneratorEventHandler extends ResultEventHandler {

	private int blackThreshold;
	
	public ContextGeneratorEventHandler(int blackThreshold) throws IOException {
		this.blackThreshold = blackThreshold;
	}
	
	@Override
	public void startQuestionItem(QuestionItemEvent ev) throws IOException {				
		super.startQuestionItem(ev);
		if (ev.getFormArea().isMarkArea()) {
			String markAreaURIPath = ev.createMarkAreaURIPath();
			float density = ev.getFormAreaCommand().getDensity();
			MarkAreaAnswerItem answerItem = new MarkAreaAnswerItem(ev.getFormArea().getItemIndex(), density, markAreaURIPath);
			((MarkAreaAnswer)ev.getAnswer()).addMarkAreaAnswerItem(answerItem);
		}
	}

	@Override
	public void endQuestion(QuestionEvent ev) throws IOException {
		if (ev.getDefaultFormArea().isMarkArea()) {
			MarkAreaAnswer answer = ((MarkAreaAnswer)ev.getAnswer());
			MarkAreaAnswerItemsByColumn markAreaAnswerByColumn = ev.getQuestionEventContext().getMarkAreaAnswerItemMapByColumn().get(ev.getColumnIndex());
			int numMarks = handleMarkArea(ev, markAreaAnswerByColumn);
			answer.setNumMarkedAnswerItems(numMarks);
			if (numMarks == 0) {
				markAreaAnswerByColumn.getAnswerItemBag().addNoAnswer();
			}
		} else if (ev.getDefaultFormArea().isTextArea()) {
			TextAreaAnswerListByColumn textAreaAnswerByColumn = ev.getQuestionEventContext().getTextAreaAnswerListMapByColumn().get(ev.getColumnIndex());
			handleTextArea(ev, textAreaAnswerByColumn);
		}

		super.endQuestion(ev);
	}
	
	private int handleMarkArea(QuestionEvent ev, MarkAreaAnswerItemsByColumn markAreaAnswerByColumn) {
		List<MarkAreaAnswerItem> markAreaAnswerItemList = ((MarkAreaAnswer)ev.getAnswer()).getMarkAreaAnswerItemList();
		MarkAreaAnswerItem[] markAreaAnswerItemArray = new MarkAreaAnswerItem[markAreaAnswerItemList.size()];
		markAreaAnswerItemArray = markAreaAnswerItemList.toArray(markAreaAnswerItemArray);
		Arrays.sort(markAreaAnswerItemArray);

		for (MarkAreaAnswerItem answerItem : markAreaAnswerItemArray) {
			markAreaAnswerByColumn.getDensityAnswerItemMap().add(answerItem);
		}

		int numMarks = 0;

		switch (ev.getDefaultFormArea().getTypeCode()) {
		case FormArea.SELECT1:
			numMarks = handleSelect1(ev, markAreaAnswerByColumn, markAreaAnswerItemList, markAreaAnswerItemArray);
			break;
		case FormArea.SELECT:
			numMarks = handleSelect(ev, numMarks, markAreaAnswerByColumn);
			break;
		}
		return numMarks;
	}

	private int handleSelect(QuestionEvent ev, int numMarks, MarkAreaAnswerItemsByColumn markAreaAnswerByColumn) {
		for (MarkAreaAnswerItem answerItem : ((MarkAreaAnswer)ev.getAnswer()).getMarkAreaAnswerItemList()) {
			if(answerItem.isManualMode()){
				if(answerItem.isManualSelected()){
					markAreaAnswerByColumn.getAnswerItemBag().add(answerItem);
					numMarks++;
				}
			}else{
				if (answerItem.getDensity() < this.blackThreshold / 255.0) {
					answerItem.set(true, true);
					markAreaAnswerByColumn.getAnswerItemBag().add(answerItem);
					numMarks++;
				} else {
					answerItem.set(false, false);
				}
			}
		}
		return numMarks;
	}

	private int handleSelect1(QuestionEvent ev, MarkAreaAnswerItemsByColumn markAreaAnswerByColumn, List<MarkAreaAnswerItem> answerItemList, MarkAreaAnswerItem[] answerItemArray) {
		int numMarks = 0;
		for (int densityIndex = 0; densityIndex < answerItemArray.length; densityIndex++) {
			MarkAreaAnswerItem answerItem = answerItemArray[densityIndex];
			if(answerItem.isManualMode()){
				if(answerItem.isManualSelected() && numMarks == 0){
					markAreaAnswerByColumn.getAnswerItemBag().add(answerItem);
					numMarks++;
					break;
				}
			}else{
				if (answerItemArray[densityIndex].getDensity() < this.blackThreshold / 255.0) {
					if (densityIndex == 0 && numMarks == 0) {
						answerItem.set(true, true);
						markAreaAnswerByColumn.getAnswerItemBag().add(answerItem);
						numMarks++;
					} else {
						answerItem.set(true, false);
					}
				} else {
					answerItem.set(false, false);
				}
			}
		}
		return numMarks;
	}
	
	private void handleTextArea(QuestionEvent ev, TextAreaAnswerListByColumn textAreaAnswerByColumn) {
		textAreaAnswerByColumn.add((TextAreaAnswer)ev.getAnswer());
	}
}
