package net.sqs2.omr.result.module.core;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.result.ImageFileUtil;
import net.sqs2.omr.result.TextAreaAnswer;
import net.sqs2.omr.result.event.QuestionItemEvent;
import net.sqs2.omr.result.event.ResultEventHandler;

public class AreaImageGeneratorEventHandler extends ResultEventHandler {
	
	public AreaImageGeneratorEventHandler() throws IOException {
		super();
	}
	
	@Override
	public void startQuestionItem(QuestionItemEvent ev) throws IOException {
		
		super.startQuestionItem(ev);
		
		if(! ev.isLeaf()){
			return;
		}
		
		if (ev.getFormArea().isMarkArea()) {
			// skip externalization of markarea image file 
			
			//writeMarkAreaImage(ev);
		}else if(ev.getFormArea().isTextArea()){
			writeTextAreaImage(ev);
		}
	}

	private void writeTextAreaImage(QuestionItemEvent ev) throws IOException {
	    File textAreaFile = ev.createTextAreaFile();
	    if(! textAreaFile.getParentFile().exists()){
	    	textAreaFile.getParentFile().mkdirs();
	    }
	    ((TextAreaAnswer)ev.getAnswer()).setTextAreaImageFilePath(textAreaFile.getPath());
	    writeFormAreaImage(ev, textAreaFile);
    }

	/*
	private void writeMarkAreaImage(QuestionItemEvent ev) throws IOException {
	    File markAreaFile = ev.createTextAreaFile();
	    if(! markAreaFile.getParentFile().exists()){
	    	markAreaFile.getParentFile().mkdirs();
	    }
	    writeFormAreaImage(ev, markAreaFile);
    }
	 */
	
	private void writeFormAreaImage(QuestionItemEvent e, File textAreaFile)throws IOException{
		ImageFileUtil.writeFormAreaImage(e.getFormMaster(), e.getPageTask(), e.getFormAreaCommand().getImageByteArray(),
				e.getFormAreaCommand().getImageType(), textAreaFile);
	}

}
