package net.sqs2.omr.result.module.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import net.sqs2.exigrid.source.PageTask;
import net.sqs2.exigrid.source.PageTaskError;
import net.sqs2.omr.result.ResultPathFactory;
import net.sqs2.omr.result.event.ResultEventHandler;
import net.sqs2.util.PathUtil;

public abstract class AbstractErrorLogHandler extends ResultEventHandler {

	ResultPathFactory resultPathFactory;
	File errorLogFile;
	PrintWriter writer;
	
	protected boolean hasError = false;


	public AbstractErrorLogHandler(ResultPathFactory resultPathFactory, String extension, String encoding)throws IOException {
		this.resultPathFactory = resultPathFactory;
		this.errorLogFile = createErrorLogFile(extension);
		this.writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(this.errorLogFile), encoding));
	}

	private File createErrorLogFile(String extension) {
		return new File(this.resultPathFactory.getResultDirectoryRoot().getAbsolutePath()+ File.separator + "errorlog."+extension);
	}
	
	public void logPageTaskError(PageTask pageTask) {
		PageTaskError pageTaskError = pageTask.getPageTaskError();
		if (pageTaskError == null) {
			return;
		}
		this.hasError = true;
		StringBuilder imagePathBuilder = new StringBuilder(32);
		imagePathBuilder.append(pageTask.getSourceDirectoryRootPath());
		imagePathBuilder.append(File.separatorChar);
		imagePathBuilder.append(pageTask.getPageID().getPath());
		String uri = PathUtil.getRelativePath(imagePathBuilder.toString(), this.errorLogFile.getAbsolutePath());

		log(pageTask, pageTaskError, uri);
		//htmlLog(pageTask, pageTaskError, uri);
	}
	
	public void close() {
		this.writer.close();
		if(! this.hasError){
			this.errorLogFile.delete();
		}
	}

	
	protected abstract void log(PageTask pageTask, PageTaskError pageTaskError, String uri);


}