/**
 *  TableEventContext.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.result.event;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

import java.util.SortedMap;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.exigrid.source.SourceDirectory;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.result.MarkAreaAnswerItem;
import net.sqs2.omr.result.AnswerItemBag;
import net.sqs2.omr.result.DensityAnswerItemMap;
import net.sqs2.omr.result.TextAreaAnswer;

public class TableEventContext extends MasterEventContext{
	
	protected SourceDirectory sourceDirectory = null;
	protected int tableIndex;

	protected int densityStatResolution;
	protected boolean isLeaf = false;

	protected List<PageID> pageIDList = null;
	protected SortedMap<PageID, ErrorByPage> errorMapByPage = null;
	protected SortedMap<Integer, MarkAreaAnswerItemsByColumn> markAreaAnswerItemMapByColumn = null;
	protected SortedMap<Integer, TextAreaAnswerListByColumn> textAreaAnswerListMapByColumn = null;
	
	public class ErrorByPage{
		private List<MarkAreaAnswerItem> errorAnswerItemList = null;
		
		ErrorByPage(){
			this.errorAnswerItemList = new ArrayList<MarkAreaAnswerItem>();
		}
		
		public void add(MarkAreaAnswerItem answerItem){
			this.errorAnswerItemList.add(answerItem);
		}
		
		public List<MarkAreaAnswerItem> getErrorAnswerItemList(){
			return this.errorAnswerItemList;
		}
	}
	
	public class MarkAreaAnswerItemsByColumn{
		private AnswerItemBag answerItemBag = null;
		private DensityAnswerItemMap densityAnswerItemMap = null;
		
		MarkAreaAnswerItemsByColumn(){
			this.answerItemBag = new AnswerItemBag();
			this.densityAnswerItemMap = new DensityAnswerItemMap(getDensityStatResolution());
		}
		
		public AnswerItemBag getAnswerItemBag(){
			return this.answerItemBag;
		}
		
		public DensityAnswerItemMap getDensityAnswerItemMap(){
			return this.densityAnswerItemMap;
		}
		
		@Override
		public String toString(){
			return "MarkAreaAnswerByColumn:"+this.answerItemBag.toString();
		}
	}
	
	public class TextAreaAnswerListByColumn implements Iterable<TextAreaAnswer>{
		private List<TextAreaAnswer> textAreaAnswerList = null;
		
		TextAreaAnswerListByColumn(){
			this.textAreaAnswerList = new ArrayList<TextAreaAnswer>();
		}
		
		public void add(TextAreaAnswer answer){
			this.textAreaAnswerList.add(answer);
		}
		
		public TextAreaAnswer get(int rowIndex){
			return this.textAreaAnswerList.get(rowIndex);
		}

		public Iterator<TextAreaAnswer> iterator() {
			return this.textAreaAnswerList.iterator();
		}
		
		@Override
		public String toString(){
			return "TextAreaAnswerByColumn:"+this.textAreaAnswerList.toString();
		}
	}

	public SortedMap<PageID, ErrorByPage> getErrorMapByPage(){
		return this.errorMapByPage;
	}

	public SortedMap<Integer, MarkAreaAnswerItemsByColumn> getMarkAreaAnswerItemMapByColumn(){
		return this.markAreaAnswerItemMapByColumn;
	}
	
	public SortedMap<Integer, TextAreaAnswerListByColumn> getTextAreaAnswerListMapByColumn(){
		return this.textAreaAnswerListMapByColumn;
	}

	public List<PageID> getPageIDList(File sourceParentDirectory){
		return this.sourceDirectory.getPageIDListMap().get(sourceParentDirectory);
	}

	TableEventContext(MasterEventContext context, SourceDirectory sourceDirectory, 
			int tableIndex, int densityStatResolution,  boolean isLeaf)throws IOException{
		//int rowBaseIndex, 
		super(context);
		this.sourceDirectory = sourceDirectory;
		this.tableIndex = tableIndex;
		//this.rowBaseIndex = rowBaseIndex;
		this.densityStatResolution = densityStatResolution;
		this.isLeaf = isLeaf;
		start();
	}
	
	TableEventContext(TableEventContext context)throws IOException{
		super(context);
		this.sourceDirectory = context.sourceDirectory;
		this.tableIndex = context.tableIndex;
		// this.rowBaseIndex = context.rowBaseIndex;
		this.densityStatResolution = context.densityStatResolution;
		this.isLeaf = context.isLeaf;
		
		this.pageIDList = context.pageIDList;
		this.errorMapByPage = context.errorMapByPage;
		this.markAreaAnswerItemMapByColumn = context.markAreaAnswerItemMapByColumn;
		this.textAreaAnswerListMapByColumn = context.textAreaAnswerListMapByColumn;
	}
	
	public boolean isLeaf(){
		return this.isLeaf;
	}
	
	SourceDirectory getSourceDirectory(){
		return this.sourceDirectory;
	}
	
	FormMaster getFormMaster(){
		return (FormMaster)this.pageMaster;
	}
	
	int getNumColumns(){
		return getFormMaster().getQIDSet().size();
	}
	
	int getTableIndex(){
		return this.tableIndex;
	}

	/*
	int getRowBaseIndex(){
		return this.rowBaseIndex;
	}
	*/
	
	int getDensityStatResolution(){
		return this.densityStatResolution;
	}
		
	public void start()throws IOException{
		this.errorMapByPage = new TreeMap<PageID, ErrorByPage>();
		this.markAreaAnswerItemMapByColumn = new TreeMap<Integer,MarkAreaAnswerItemsByColumn>();
		this.textAreaAnswerListMapByColumn = new TreeMap<Integer,TextAreaAnswerListByColumn>();
	}
	
	public void stop(){
	}
}
