/**
 * 
 */
package net.sqs2.omr.result.event;

import net.sqs2.exigrid.source.SourceDirectory;

public class TableEvent extends MasterEvent {
	protected TableEventContext tableEventContext;

	TableEvent(TableEventContext context) {
		super(context);
		this.tableEventContext = context;
	}

	public SourceDirectory getSourceDirectory() {
		return this.tableEventContext.getSourceDirectory();
	}

	public int getTableIndex(){
		return this.tableEventContext.getTableIndex();
	}

	public int getNumTables(){
		return this.tableEventContext.getNumTables();
	}

	public boolean isLeaf(){
		return this.tableEventContext.isLeaf();
	}
	
	public TableEventContext getTableEventContext(){
		return this.tableEventContext;
	}
	
	public String toString() {
		return super.toString() + " " + getTableIndex() + "/" + getNumTables() + " " + (isLeaf()?"":"*");
	}

}