package net.sqs2.omr.result.event;

import java.io.File;
import java.io.IOException;

import net.sqs2.omr.result.Row;
import net.sqs2.util.PathUtil;

public class RowEventContext extends TableEventContext {

    protected File sourceParentDirectory;
    protected int pageIDIndex;
    protected int rowIndex;
    protected int numRows;

    protected Row row;
    protected boolean isDirtyRow = false;

    RowEventContext(TableEventContext context, File sourceParentDirectory, int pageIDIndex, int rowIndex, int numRows) throws IOException {
        super(context);
        this.sourceParentDirectory = sourceParentDirectory;
        this.pageIDIndex = pageIDIndex;
        this.rowIndex = rowIndex;
        this.numRows = numRows;
        start();
    }

    RowEventContext(RowEventContext context)throws IOException {
        super(context);
        this.sourceParentDirectory = context.sourceParentDirectory;
        this.pageIDIndex = context.pageIDIndex;
        this.rowIndex = context.rowIndex;
        this.numRows = context.numRows;
        this.row = context.row;
        this.isDirtyRow = context.isDirtyRow;
    }

    File getSourceParentDirectory() {
        return this.sourceParentDirectory;
    }

    int getPageIDIndex() {
        return this.pageIDIndex;
    }

    int getRowIndex() {
        return this.rowIndex;
    }

    int getNumRows() {
        return this.numRows;
    }

    public Row getRow() {
        return this.row;
    }

    public void start() throws IOException {
        this.row = new Row(getFormMaster().getPath(),
                PathUtil.getRelativePath(getSourceParentDirectory(), getSourceDirectory().getDirectoryRoot()),
                getPageIDIndex(),
                getNumColumns());
    }
    
    public void setDirtyRow(boolean isDirtyRow){
    	this.isDirtyRow = isDirtyRow;
    }

    public boolean isDirtyRow(){
    	return this.isDirtyRow;
    }

    public void stop() {
        if (this.isDirtyRow) {
            this.rowAccessor.put(this.row);
            this.rowAccessor.flush();
            this.isDirtyRow = false;
        }
    }
}
