/**
 
 ResultEvent.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/07/24

 */
package net.sqs2.omr.result.event;

import java.io.File;
import java.util.List;

import net.sqs2.exigrid.source.PageID;

public class RowEvent extends TableEvent {
	
	RowEventContext rowEventContext;
	
    RowEvent(RowEventContext context) {
    	super(context);
    	this.rowEventContext = context;
    }
    
    public int getRowIndex(){
    	return this.rowEventContext.getRowIndex();
    }

    public int getNumRows(){
    	return this.rowEventContext.getNumRows();
    }

    int getPageIDIndex(){
    	return this.rowEventContext.getPageIDIndex();
    }
    
    public File getSourceParentDirectory(){
    	return this.rowEventContext.getSourceParentDirectory();
    }
    
    public List<PageID> getPageIDList(){
    	return this.rowEventContext.getPageIDList(getSourceParentDirectory());
    }
    
    public RowEventContext getRowEventContext(){
    	return this.rowEventContext;
    }

    public String toString() {
		return super.toString()+" "+getRowIndex()+"/"+getNumRows() + " " + (isLeaf()?"":"*");
	}

}
