package net.sqs2.omr.result.event;

import java.io.File;

public class ResultEventFilterImpl implements ResultEventFilter {

	public static final int ACCEPT_DESCENDANT_LEAF_MODE = 1;
	public static final int ACCEPT_SHARED_BRANCH_MODE = 2;
	public static final int ACCEPT_DESCENDANT_LEAF_AND_SHARED_BRANCH_MODE = 3;
	public static final int ACCEPT_SELF_ONLY_MODE = 4;
	
	private int mode; 
	private String masterPath;
	private String sourceDirectoryPath = null;
	private int rowIndexStart = -1, rowIndexEnd = -1;
	
	public ResultEventFilterImpl(int mode, String masterPath){
		this.mode = mode;
		this.masterPath = masterPath;
	}
	
	public ResultEventFilterImpl(int mode, String masterPath, String sourceDirectoryPath){
		this(mode, masterPath);
		this.sourceDirectoryPath = sourceDirectoryPath;
	}
	
	public ResultEventFilterImpl(int mode, String masterPath, String sourceDirectoryPath, int rowIndexStart, int rowIndexEnd){
		this(mode, masterPath, sourceDirectoryPath);
		this.rowIndexStart = rowIndexStart;
		this.rowIndexEnd = rowIndexEnd;
	}
	
	public int getMode(){
		return this.mode;
	}
	
	public boolean accept(MasterEventContext masterEventContext) {
		return this.masterPath.equals(masterEventContext.getPageMaster().getPath());
	}

	public boolean accept(TableEventContext tableEventContext) {
		if(this.sourceDirectoryPath == null){
			return true;
		}
	
		String targetPath = tableEventContext.getSourceDirectory().getPath();
		String filterPath = this.sourceDirectoryPath;
		
		String targetPath_ = targetPath+File.separatorChar;
		String filterPath_ = filterPath+File.separatorChar;
		
		if(targetPath.equals(filterPath)){
			// targetPath == filterPath
			return targetPath.equals(filterPath);
		}

		if(this.mode == ACCEPT_DESCENDANT_LEAF_AND_SHARED_BRANCH_MODE){
			if(filterPath.length() <= targetPath.length()){
				// descendant leaf
				return targetPath.startsWith(filterPath_);
			}else{
				// share branch
				return filterPath.startsWith(targetPath_);
			}
		}else if(this.mode == ACCEPT_DESCENDANT_LEAF_MODE){
			// descendant leaf
			return targetPath.startsWith(filterPath_);
		}else if(this.mode == ACCEPT_SHARED_BRANCH_MODE){
			// share branch
			return filterPath.startsWith(targetPath_);
		}else if(this.mode == ACCEPT_SELF_ONLY_MODE){
			// targetPath == filterPath
			return targetPath.equals(filterPath_);
		}else{
			return false;
		}
	}

	public boolean accept(RowEventContext rowEventContext) {
		
		if(! accept((TableEventContext)rowEventContext)){
			return false;
		}

		if(this.rowIndexStart == -1 || this.mode != ACCEPT_SELF_ONLY_MODE){
			return true;
		}

		String targetPath = (rowEventContext.getSourceDirectory().getPath()+File.separatorChar);
		String filterPath = (this.sourceDirectoryPath+File.separatorChar);
		if(! targetPath.equals(filterPath)){
			return false;
		}

		int rowIndex = rowEventContext.getRowIndex() ;
		return rowIndexStart <= rowIndex && rowIndex <= rowIndexEnd;
	}

	public boolean accept(QuestionEventContext questionEventContext) {
		
		if(! accept((RowEventContext)questionEventContext)){
			return false;
		}

		// always true
		return true;
	}
}
