package net.sqs2.omr.result.event;

import java.util.LinkedHashMap;
import java.util.SortedSet;
import java.util.TreeSet;

import net.sqs2.omr.result.CellIndex;


public class ResultEventFilterByAcceptableQuestionImpl extends ResultEventFilterImpl implements ResultEventFilterByAcceptableQuestion {

    LinkedHashMap<String, LinkedHashMap<String, SortedSet<CellIndex>>> map = new LinkedHashMap<String, LinkedHashMap<String, SortedSet<CellIndex>>>();

    public ResultEventFilterByAcceptableQuestionImpl(String masterPath) {
        super(ResultEventFilterImpl.ACCEPT_DESCENDANT_LEAF_AND_SHARED_BRANCH_MODE,
                masterPath);
    }

	/*
	 * Add acceptable Question by parameters
	 * @Override
	 * @param masterPath  
	 * @param sourceDirectoryPath  
	 * @param rowIndex
	 * @param columnIndex
	 */
    public void addAcceptableQuestion(String masterPath, String sourceDirectoryPath, int rowIndex, int columnIndex) {
        LinkedHashMap<String, SortedSet<CellIndex>> m = getCellIndexSetMap(masterPath);
        if (m == null) {
            m = new LinkedHashMap<String, SortedSet<CellIndex>>();
            this.map.put(masterPath, m);
        }
        SortedSet<CellIndex> s = m.get(sourceDirectoryPath);
        if (s == null) {
            s = new TreeSet<CellIndex>();
            m.put(sourceDirectoryPath, s);
        }
        s.add(new CellIndex(rowIndex, columnIndex));
    }

	/*
	 * Add acceptable Question Set<CellIndex>
	 * @Override
	 * @param masterPath  
	 * @param sourceDirectoryPath  
	 * @param rowIndex
	 * @param columnIndex
	 */
    public void addAcceptableQuestionList(String masterPath, String sourceDirectoryPath, SortedSet<CellIndex> cellIndexSet) {
        LinkedHashMap<String, SortedSet<CellIndex>> m = getCellIndexSetMap(masterPath);
        if (m == null) {
            m = new LinkedHashMap<String, SortedSet<CellIndex>>();
            this.map.put(masterPath, m);
        }
        m.put(sourceDirectoryPath, cellIndexSet);
    }

    @Override
    public boolean accept(MasterEventContext masterEventContext) {
        return getCellIndexSetMap(masterEventContext) != null;
    }

    @Override
    public boolean accept(TableEventContext tableEventContext) {
        return getCellIndexSet(tableEventContext.getPageMaster().getPath(), tableEventContext.getSourceDirectory().getPath()) != null;
    }

    @Override
    public boolean accept(RowEventContext rowEventContext) {
        if (!super.accept(rowEventContext)) {
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(QuestionEventContext questionEventContext) {
        if (!super.accept(questionEventContext)) {
            return false;
        }
        SortedSet<CellIndex> set = getCellIndexSet(questionEventContext);
        return set != null && set.contains(new CellIndex(questionEventContext.getRowIndex(), questionEventContext.getColumnIndex()));
    }

    // private

    private LinkedHashMap<String, SortedSet<CellIndex>> getCellIndexSetMap(MasterEventContext masterEventContext) {
        return getCellIndexSetMap(masterEventContext.getPageMaster().getPath());
    }

    private LinkedHashMap<String, SortedSet<CellIndex>> getCellIndexSetMap(String masterPath) {
        return this.map.get(masterPath);
    }

    private SortedSet<CellIndex> getCellIndexSet(String masterPath, String sourceDirectoryPath) {
        LinkedHashMap<String, SortedSet<CellIndex>> ret = getCellIndexSetMap(masterPath);
        if (ret == null) {
            return null;
        }
        return ret.get(sourceDirectoryPath);
    }

    private SortedSet<CellIndex> getCellIndexSet(TableEventContext tableEventContext) {
        return getCellIndexSet(tableEventContext.getFormMaster().getPath(), tableEventContext.getSourceDirectory().getPath());
    }

}
