/**

 ResultEventContext.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/07/24
 */
package net.sqs2.omr.result.event;

import java.io.File;
import java.io.IOException;
import java.util.Set;

import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.source.PageTaskAccessor;
import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.omr.result.ResultPathFactory;
import net.sqs2.omr.result.RowAccessor;

public class ResultEventContext {

    protected SessionSource sessionSource;
    protected ResultPathFactory resultPathFactory;
    protected PageTaskAccessor pageTaskAccessor;
    protected RowAccessor rowAccessor;

    public ResultEventContext(SessionSource sessionSource,
                       ResultPathFactory resultPathFactory) throws IOException {
        this.sessionSource = sessionSource;
        this.resultPathFactory = resultPathFactory;
        start();
    }

    public ResultEventContext(ResultEventContext context) throws IOException{
        this.sessionSource = context.sessionSource;
        this.resultPathFactory = context.resultPathFactory;
        this.pageTaskAccessor = context.pageTaskAccessor;
        this.rowAccessor = context.rowAccessor;
    }

    public Set<PageMaster> getPageMasterSet() {
        return this.sessionSource.getPageMasterSet();
    }

    int getNumMasters() {
        return this.sessionSource.getPageMasterSet().size();
    }

    public File getSourceDirectoryRoot() {
        return this.sessionSource.getSourceDirectoryRoot();
    }

    public ResultPathFactory getResultPathFactory() {
        return this.resultPathFactory;
    }

    public RowAccessor getRowAccessor() {
        return this.rowAccessor;
    }

    public void start() throws IOException {
        this.rowAccessor = new RowAccessor(this.resultPathFactory.getSourceDirectoryRoot(),
                this.resultPathFactory.getResultDirectoryRoot());
        this.pageTaskAccessor = new PageTaskAccessor(this.resultPathFactory.getSourceDirectoryRoot(),
                this.resultPathFactory.getResultDirectoryRoot());
    }

    public void stop() {
        this.rowAccessor.flush();
        this.pageTaskAccessor.flush();
    }
}
