package net.sqs2.omr.result.event;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.exigrid.source.PageTask;
import net.sqs2.exigrid.source.PageTaskImpl;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.result.MarkAreaAnswerItem;
import net.sqs2.omr.result.MarkAreaAnswer;
import net.sqs2.omr.source.FormAreaCommand;

public class QuestionItemEventContext extends QuestionEventContext{
	protected int itemIndex;
	protected FormArea formArea;
	
	protected PageID prevPageID;
	protected PageID pageID;
	
	protected FormAreaCommand formAreaCommand;
	
	protected String pageTaskID;
	protected PageTask pageTask;
	
	protected QuestionItemEventContext prevQuestionItemEventContext;

	QuestionItemEventContext(QuestionEventContext context, int itemIndex, QuestionItemEventContext prevQuestionItemEventContext)throws IOException{
		super(context);
		this.itemIndex = itemIndex;
		this.prevQuestionItemEventContext = prevQuestionItemEventContext;
		this.formArea = this.formAreaList.get(itemIndex);
		Map<File, List<PageID>> pageIDListMap = this.sourceDirectory.getPageIDListMap();
		List<PageID> pageIDList = pageIDListMap.get(this.sourceParentDirectory);
		this.pageID = pageIDList.get(this.rowIndex * this.getFormMaster().getNumPages() + this.formArea.getPage() - 1);
		start();
	}

	QuestionItemEventContext(QuestionItemEventContext context)throws IOException{
		super(context);
		this.itemIndex = context.itemIndex;
		this.prevQuestionItemEventContext = context.prevQuestionItemEventContext;
		this.formArea = context.formArea;
		this.pageID = context.pageID;
		this.pageTaskID = context.pageTaskID;
		this.pageTask = context.pageTask;
	}
		
	FormArea getFormArea(){
		return this.formArea;
	}
	
	PageID getPageID(){
		return this.pageID;
	}
	
	void setPageTask(PageTask pageTask){
		this.pageTask = pageTask;
	}
	
	public PageTask getPageTask(){
		return this.pageTask;
	}
	
	String getPageTaskID(){
		return this.pageTaskID;
	}
	
	FormAreaCommand getFormAreaCommand(){
		return this.formAreaCommand;
	}
	
	void setFormAreaCommand(FormAreaCommand formAreaCommand){
		this.formAreaCommand = formAreaCommand; 
	}
	
	MarkAreaAnswerItem getMarkAreaAnswerItem(){
		if(this.formArea.isMarkArea()){
			return ((MarkAreaAnswer)this.answer).getMarkAreaAnswerItem(this.formArea.getItemIndex());
		}else{
			return null;
		}
	}
	
	public int getItemIndex(){
		return this.itemIndex;
	}
	
	public void start() throws IOException{
		this.pageTaskID = PageTaskImpl.createID(getFormMaster().getFileResource(),
				this.formArea.getPage(), getPageID());
		if (this.pageTask == null || this.prevQuestionItemEventContext == null ||
				! this.pageTaskID.equals(this.prevQuestionItemEventContext.getPageTaskID())) {
			this.pageTask = (PageTask) this.pageTaskAccessor.get(this.pageTaskID);
			//System.out.println(this.pageTaskID);
		}else{
			this.pageTask = this.prevQuestionItemEventContext.getPageTask();
		}
	}
	
	public void stop(){}
}