/**
 * 
 */
package net.sqs2.omr.result.event;

import java.io.File;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.exigrid.source.PageTask;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.result.AreaImagePathInfo;
import net.sqs2.omr.result.MarkAreaAnswerItem;
import net.sqs2.omr.source.FormAreaCommand;

public class QuestionItemEvent extends QuestionEvent {

	protected QuestionItemEventContext questionItemEventContext;

	QuestionItemEvent(QuestionItemEventContext context) {
		super(context);
		this.questionItemEventContext = context;
	}

	public FormArea getFormArea() {
		return this.questionItemEventContext.getFormArea();
	}

	public PageTask getPageTask() {
		return this.questionItemEventContext.getPageTask();
	}

	public FormAreaCommand getFormAreaCommand() {
		return this.questionItemEventContext.getFormAreaCommand();
	}

	public MarkAreaAnswerItem getMarkAreaAnswerItem(){
		return this.questionItemEventContext.getMarkAreaAnswerItem();
	}

	public String createMarkAreaURIPath(){
		return getMarkAreaURIPath( 
				this.questionItemEventContext.getPageID().getPath(), 
				this.questionItemEventContext.getPageID().getIndex(),
				getMasterIndex(),
				getColumnIndex(), 
				getFormArea().getItemIndex(), 
				getFormAreaCommand().getImageType());
	}

	public String getMarkAreaURIPath(String sourceFilePath,
			int pageIndex, int masterIndex, int questionIndex, int itemIndex, String ext) {
		return new AreaImagePathInfo(sourceFilePath, pageIndex, masterIndex, questionIndex, itemIndex, ext).toPathInfo();
	}

	public File createTextAreaFile(){
		//Logger.getAnonymousLogger().info("**** PageID:"+this.questionItemEventContext.getPageID());
		return getResultPathFactory().getTextAreaFile(getFormMaster().getPath(), 
				getSourceDirectory().getPath(), this.questionItemEventContext.getPageID(), 
				getColumnIndex(), getFormAreaCommand().getImageType());
	}

	public QuestionItemEventContext getQuestionItemEventContext(){
		return this.questionItemEventContext;
	}

	public PageID getPageID(){
		return this.questionItemEventContext.getPageID();
	}

	public String toString() {
		return super.toString()+" "+this.questionItemEventContext.getItemIndex() + " " + (isLeaf()?"":"*");
	}

}