/**
 *  QuestionEventContext.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.result.event;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import net.sqs2.omr.result.Answer;
import net.sqs2.omr.result.MarkAreaAnswer;
import net.sqs2.omr.result.TextAreaAnswer;

import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;

public class QuestionEventContext extends RowEventContext{
	protected String qid = null;
	protected int columnIndex;
	//protected boolean isBase;
	
	protected ArrayList<FormArea> formAreaList = null;
	protected int numQuestionItems;

	protected Answer answer = null;
	
	QuestionEventContext(RowEventContext context, String qid, int columnIndex)throws IOException{
		super(context);
		this.qid = qid;
		this.columnIndex = columnIndex;

		this.formAreaList = ((FormMaster)context.pageMaster).getFormAreaList(qid);
		this.numQuestionItems = formAreaList.size();
		
		start();
	}
	
	QuestionEventContext(QuestionEventContext context)throws IOException{
		super(context);
		this.qid = context.qid;
		this.columnIndex = context.columnIndex;
		//this.isBase = context.isBase;
		
		this.formAreaList = context.formAreaList;
		this.numQuestionItems = context.numQuestionItems;
		this.answer = context.answer;
	}
	/*
	void setBase(boolean isBase){
		this.isBase = isBase;
	}
	
	boolean getBase(){
		return this.isBase;
	}
	public boolean isBase(){
		return this.isBase;
	}
	
 	*/
	
	String getQID(){
		return this.qid;
	}
	
	int getNumQuestionItems(){
		return this.numQuestionItems;
	}
	
	FormArea getDefaultFormArea(){
		return this.formAreaList.get(0);
	}
	
	List<FormArea> getFormAreaList(){
		return this.formAreaList;
	}
	
	public int getColumnIndex() {
		return this.columnIndex;
	}
	
	public void start() throws IOException{
		if(this.answer != null){
			return;
		}
		if (getDefaultFormArea().isMarkArea()) {
			this.answer = new MarkAreaAnswer();
			MarkAreaAnswerItemsByColumn markAreaAnswerItemsByColumn = getMarkAreaAnswerItemMapByColumn().get(getColumnIndex());
			if(markAreaAnswerItemsByColumn == null){
				markAreaAnswerItemsByColumn = new MarkAreaAnswerItemsByColumn();
				getMarkAreaAnswerItemMapByColumn().put(getColumnIndex(), markAreaAnswerItemsByColumn);
			}

		}else if(getDefaultFormArea().isTextArea()){
			this.answer = new TextAreaAnswer();
			TextAreaAnswerListByColumn textAreaAnswerByColumn = getTextAreaAnswerListMapByColumn().get(getColumnIndex());
			if(textAreaAnswerByColumn == null){
				textAreaAnswerByColumn = new TextAreaAnswerListByColumn();
				getTextAreaAnswerListMapByColumn().put(getColumnIndex(), textAreaAnswerByColumn);
			}
		}
	}
	
	public void stop(){
		this.row.put(getColumnIndex(), this.answer);
		this.isDirtyRow = true;
	}
	
	public Answer getAnswer(){
		return this.answer;
	}
	
	public void setAnswer(Answer answer){
		setDirtyRow(true);
		this.answer = answer;
	}
}
