/**
 * 
 */
package net.sqs2.omr.result.event;

import java.util.List;

import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.result.Answer;

public class QuestionEvent extends RowEvent {
	
	protected QuestionEventContext questionEventContext;
	
	QuestionEvent(QuestionEventContext context) {
		super(context);
		this.questionEventContext = context;
	}
	
	public List<FormArea> getFormAreaList() {
		return this.questionEventContext.getFormAreaList();
	}

	public FormArea getDefaultFormArea() {
		return this.questionEventContext.getDefaultFormArea();
	}

	public String getQID() {
		return this.questionEventContext.getDefaultFormArea().getQID();
	}

	public int getColumnIndex() {
		return this.questionEventContext.getColumnIndex();
	}

	public int getRowIndex() {
		return this.questionEventContext.getRowIndex();
	}
	
	public Answer getAnswer(){
		return this.questionEventContext.getAnswer();
	}
	
	public QuestionEventContext getQuestionEventContext(){
		return this.questionEventContext;
	}
	
    public String toString() {
		return super.toString()+" "+getColumnIndex()+"/"+getNumColumns() + " " + (isLeaf()?"":"*");
	}

}