/**
 *  MasterEventContext.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.result.event;

import java.io.IOException;
import java.util.List;

import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.source.SourceDirectory;
import net.sqs2.omr.result.RowAccessor;


public class MasterEventContext extends ResultEventContext {
    protected PageMaster pageMaster = null;
    protected int numTables;
    protected int masterIndex;

    MasterEventContext(ResultEventContext context, PageMaster pageMaster, int masterIndex, int numTables) throws IOException {
        super(context);
        this.pageMaster = pageMaster;
        this.masterIndex = masterIndex;
        this.numTables = numTables;
        start();
    }

    MasterEventContext(MasterEventContext context) throws IOException{
        super(context);
        this.pageMaster = context.pageMaster;
        this.masterIndex = context.masterIndex;
        this.numTables = context.numTables;
    }

    List<SourceDirectory> getSourceDirectoryList() {
        return this.sessionSource.getSourceDirectoryList(this.pageMaster);
    }

    PageMaster getPageMaster() {
        return this.pageMaster;
    }

    int getNumTables() {
        return this.numTables;
    }

    int getMasterIndex() {
        return this.masterIndex;
    }

    public RowAccessor getRowAccessor() {
        return this.rowAccessor;
    }

    public void start() throws IOException {
    	// do nothing.
    }

    public void stop() {
    	// do nothing.
    }
}
