/**
 * 
 */
package net.sqs2.omr.result.event;

import net.sqs2.omr.master.FormMaster;

public class MasterEvent extends ResultEventImpl {

	protected MasterEventContext masterEventContext;
	
	MasterEvent(MasterEventContext context) {
		super(context);
		this.masterEventContext = context;
	}

	public FormMaster getFormMaster(){
		return (FormMaster)this.masterEventContext.getPageMaster();
	}
	
	public int getMasterIndex(){
		return this.masterEventContext.getMasterIndex();
	}

	public String getSourceDirectoryRootPath(){
		return this.masterEventContext.getSourceDirectoryRoot().getPath();
	}

	public int getNumColumns(){
		return getFormMaster().getQIDSet().size();
	}
	
	public MasterEventContext getMasterEventContext(){
		return this.masterEventContext;
	}
	
	public String toString() {
		return super.toString()+" "+getMasterIndex()+"/"+getNumMasters();
	}
}