package net.sqs2.omr.result.event;

import java.io.File;
import java.io.IOException;

import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.omr.result.ResultPathFactory;

public abstract class AbstractResultEventSource{

	private SessionSource sessionSource;
	private ResultPathFactory resultPathFactory;
	private boolean isRunning;

	AbstractResultEventSource(SessionSource sessionSource, ResultPathFactory resultPathFactory){
		this.sessionSource = sessionSource;
		this.resultPathFactory = resultPathFactory;
	}
	
	protected int getNumTables(PageMaster master) {
		int numTables = this.sessionSource.getSourceDirectoryList(master).size();
		return numTables;
	}

	protected ResultEventContext createResultEventContext() throws IOException {
		ResultEventContext context = new ResultEventContext(this.sessionSource, this.resultPathFactory);
		return context;
	}
	
	protected boolean isSourceDirectoryMember(File superDirectory) {
		String sourceDirectoryPath = superDirectory.getAbsolutePath();
		String sourceDirectoryRootPath = this.sessionSource.getSourceDirectoryRoot().getAbsolutePath();
		if(sourceDirectoryPath.equals(sourceDirectoryRootPath)){
			return true;
		}else{
			return sourceDirectoryPath.startsWith(sourceDirectoryRootPath+File.separatorChar);
		}
	}
	
	public void start() {
		this.isRunning = true;
		generateEvents();
	}

	public void stop() {
		this.isRunning = false;
	}

	public void shutdown() {
		stop();
	}
	
	protected boolean isRunning(){
		return this.isRunning;
	}

	abstract protected boolean generateEvents();
}
