/**
 *  RowStore.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/03/13
 Author hiroya
 */
package net.sqs2.omr.result;

import java.io.Serializable;

public class Row extends AbstractRow implements Serializable {
	private static final long serialVersionUID = 2;

	Answer[] data;

	public Row() {
	}

	public Row(String masterPath, String sourceDirectoryPath, int rowIndex, int numColumns) {
		super(masterPath, sourceDirectoryPath, rowIndex);
		this.data = new Answer[numColumns];
	}

	public void put(int columnIndex, Answer answer) {
		this.data[columnIndex] = answer;
	}

	public Answer get(int columnIndex) {
		return this.data[columnIndex];
	}
}