/*

 ResultPathUtil.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.omr.result;

import java.io.File;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.source.config.FormResultConfig;
import net.sqs2.util.FileUtil;

public class ResultPathFactory extends AbstractResultPathFactory {

	public ResultPathFactory(File sourceDirectoryRoot,
			File resultDirectoryRoot, FormResultConfig resultConfig, int mode) {
		super(sourceDirectoryRoot, resultDirectoryRoot, resultConfig, mode);
	}

    public static final int MASTERDIR_MODE = 0;
    public static final int MASTERNAME_MODE = 1;
    public static final int MASTERNAME_SOURCEDIR_MODE = 2;
    public static final int MASTERINDEX_MODE = 3;

    //public File getResultMasterDirectory(String masterPath) {
    public File getResultMasterDirectory(FormMaster master) {
		//File masterFile = new File(masterPath);
		File resultMasterDirectory = null;
		switch (this.mode) {
		case MASTERDIR_MODE:
			resultMasterDirectory = new File(this.resultDirectoryRoot.getAbsolutePath() +
					File.separatorChar + FileUtil.getBasepath(master.getPath()));
			break;
		case MASTERNAME_SOURCEDIR_MODE:
			resultMasterDirectory = new File(this.resultDirectoryRoot.getAbsolutePath() +
					File.separatorChar + FileUtil.getBasename(master.getPath())); // + sourceDirectoryRelativePath
			break;
		case MASTERNAME_MODE:
			resultMasterDirectory = new File(this.resultDirectoryRoot.getAbsolutePath() +
					File.separatorChar +FileUtil.getBasename(master.getPath()));
			break;
		case MASTERINDEX_MODE:
			resultMasterDirectory = new File(this.resultDirectoryRoot.getAbsolutePath() +
					File.separatorChar +master.getMasterIndex());
			break;
		default:
			throw new IllegalArgumentException("ResultPathUtil#mode=" + this.mode);
		}
		return resultMasterDirectory;
	}
	
	public File getResultMasterDirectoryIndexFile(FormMaster master) {
		return new File(getResultMasterDirectory(master), "index.html");
	}
	
	public File getResultMasterDirectory(String masterPath, String sourceDirectoryRelativePath) {
		File masterFile = new File(masterPath);
		return new File(this.resultDirectoryRoot.getAbsolutePath() +
				File.separatorChar + FileUtil.getBasename(masterFile.getName()) +
				File.separatorChar + sourceDirectoryRelativePath ); 
	}

	public File getResultMasterDirectoryIndexFile(String masterPath, String sourceDirectoryRelativePath) {
		return new File(getResultMasterDirectory(masterPath, sourceDirectoryRelativePath), "index.html"); 
	}

	@Override
	public File getResultMasterColumnFile(String masterPath,
			String sourceDirectoryRelativePath, int columnIndex, String ext) {
		return new File(getResultMasterDirectoryIndexFile(masterPath, sourceDirectoryRelativePath), columnIndex + DOT + ext);
	}

	@Override
	public File getResultMasterPageFile(String masterPath,
			String sourceDirectoryRelativePath, PageID pageID, String ext) {
		return new File(getResultMasterPageDirectory(masterPath, sourceDirectoryRelativePath, pageID).getAbsolutePath() + DOT + ext);
	}

	private File getResultMasterPageDirectory(String masterPath,
			String sourceDirectoryRelativePath, PageID pageID) {
		File resultMasterDirectory = getResultMasterDirectoryIndexFile(masterPath, sourceDirectoryRelativePath).getParentFile();
		File masterParent = new File(this.sourceDirectoryRoot.getAbsolutePath() + File.separatorChar + masterPath).getParentFile();
		String pagePath;
		if (new File(pageID.getPath()).isAbsolute()) {
			pagePath = pageID.getPath().substring(masterParent.getAbsolutePath().length());
		} else {
			pagePath = pageID.getPath();
		}
		File ret = null;
		if (pageID.getNumPagesInFile() == 1) {
			ret = new File(resultMasterDirectory.getAbsolutePath() + File.separatorChar + pagePath);
		} else {
			ret = new File(resultMasterDirectory.getAbsolutePath() + File.separatorChar + pagePath + File.separatorChar + pageID.getIndex());
		}
		return ret;
	}
}
