package net.sqs2.omr.result;

import java.awt.Rectangle;

public class RectImagePathInfo extends ImagePathInfo {
	int pageIndex;
	Rectangle rectangle;
	public RectImagePathInfo(String pageFilePath, int pageIndexInFile,
			int masterIndex, int pageIndex, Rectangle rectangle, String extension){
		super(pageFilePath, pageIndexInFile, masterIndex, extension);
		this.pageIndex = pageIndex;
		this.rectangle = rectangle;
	}

	public Rectangle getRectangle(){
		return this.rectangle;
	}
	
	@Override
	public String toPathInfo() {
		return this.pageFilePath + SLASH + pageIndexInFile + SLASH + 
		masterIndex + SLASH + 
		pageIndex + SLASH + 
		rectangle.x + DASH + rectangle.y + SLASH +
		rectangle.width + DASH + rectangle.height +
		DOT + extension;
	}
	
	public static RectImagePathInfo parse(String src){
		try{
			int pExt = src.lastIndexOf(DOT);
			String ext = src.substring(pExt + 1);

			int pHeight = src.lastIndexOf(DASH, pExt - 1);
			int height = Integer.parseInt(src.substring(pHeight + 1, pExt));

			int pWidth = src.lastIndexOf(SLASH, pHeight - 1);
			int width  = Integer.parseInt(src.substring(pWidth + 1, pHeight));

			int pY = src.lastIndexOf(DASH, pWidth - 1);
			int y = Integer.parseInt(src.substring(pY + 1, pWidth));

			int pX = src.lastIndexOf(SLASH, pY - 1);
			int x  = Integer.parseInt(src.substring(pX + 1, pY));

			int pPageIndex = src.lastIndexOf(SLASH, pX - 1);
			int pageIndex  = Integer.parseInt(src.substring(pPageIndex + 1, pX));

			int pMasterIndex = src.lastIndexOf(SLASH, pPageIndex - 1);
			int masterIndex  = Integer.parseInt(src.substring(pMasterIndex + 1, pPageIndex));

			int pPageIndexInFile = src.lastIndexOf(SLASH, pMasterIndex - 1);
			int pageIndexInFile  = Integer.parseInt(src.substring(pPageIndexInFile + 1, pMasterIndex));

			String sourceFilePath = src.substring(0, pPageIndexInFile);

			return new RectImagePathInfo(sourceFilePath, pageIndexInFile, masterIndex, pageIndex, new Rectangle(x, y, width, height), ext);
		}catch(NullPointerException ex){
			return null;
		}
	}

	@Override
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		try{
			RectImagePathInfo api = (RectImagePathInfo)o;
			return super.equals(api) &&
			api.rectangle.equals(this.rectangle);
		}catch(NullPointerException ex){
			return false; 
		}catch(ClassCastException ex){
			return false; 
		}
	}
	
	public int getPageIndex(){
		return this.pageIndex;
	}
}
