/**
 *  AnswerItem.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/03/13
 Author hiroya
 */
package net.sqs2.omr.result;

import java.io.Serializable;

public class MarkAreaAnswerItem implements Comparable<MarkAreaAnswerItem>, Serializable {
    private static final long serialVersionUID = 3L;

    private int itemIndex;
    private double density;
    private String areaImageURIPath;
    
    //private String pagePath;
    //private int pageIndex;

    private boolean isMarked;
    private boolean isAutoSelected;
    private boolean isManualSelected;

    private boolean isManualMode = false;

    public MarkAreaAnswerItem() {
    }

    public MarkAreaAnswerItem(int itemIndex, double density, String areaImageURIPath) {
        this.itemIndex = itemIndex;
        this.density = density;
        this.areaImageURIPath = areaImageURIPath;
    }
    
    /**
     * このメソッドはContextGeneratorEventHandlerクラスからのみ呼び出される．
     * それ以外の場所から呼び出してはならない．
     * 原則としてsetAutoSelectedとセットで実行される．
    */
   public void set(boolean isMarked, boolean isAutoSelected) {
        this.isMarked = isMarked;
        this.isAutoSelected = isAutoSelected;
    }

    /**
     * @return 画像を単純に濃度解析した結果，マークが塗られていると判断した場合にはtrue，そうでない場合にはfalseを返す．
     */
    public boolean isMarked() {
        return this.isMarked;
    }
 
    /** 
     * 原則として，isMarkedと同じ値を返す．ただし，例外的状況では異なる値を返す．
     * たとえば，設問が択一選択型で，ダブルマークされている場合には，
     * 濃く塗られている選択肢はすべてisMarkedがtrueになるが，
     * 1番濃度が濃い選択肢だけisAutoSelectedがtrueになる．
     *  この値は，isAutoSelectedがtrueのときのみ利用される．
     * @return 設問の他の選択肢の状況を考慮して，マークされていると判断される場合にはtrueを，そうでない場合にはfalseを返す．
     */
    public boolean isAutoSelected() {
        return this.isAutoSelected;
    }
   
    /**
     * WebUIなどを介して，ユーザの判断により，マークが塗られているものと指定された場合
     * (isMarkedやisAutoSelectedなどのシステムによる自動的な判断を，ユーザの判断が上書きする場合)には
     * isManualModeをtrueにsetする．
    */
    public void setManualMode(boolean isManualMode) {
        this.isManualMode = isManualMode;
    }
    
    /**
     * @return  WebUIなどを介して，ユーザの判断により，マークが塗られているものと指定されている場合にはtrue, そうでない場合にはfalseを返す．
     */
    public boolean isManualMode() {
        return this.isManualMode;
    }
    
    /**
    * ユーザの判断により，マークが塗られているものと指定された場合には
    * isManualModeをtrueにsetした上で，
    * isManualSelectMode を trueないしfalseにsetする．
    * この値は，isManualModeがtrueのときのみ利用される．
    */
    public void setManualSelected(boolean isManualSelected) {
    	this.isManualMode = true;
        this.isManualSelected = isManualSelected;
    }
    public boolean isManualSelected() {
        return this.isManualSelected;
    }

    /**
     * isManualMode,isManualSelectMode, isAutoSelectedから
     * 総合的に判断して，このマークは選択状態であるかどうかを返す． 
     * @return このマークは選択状態と判断される場合にはtrue，そうでない場合にはfalse
     */
    public boolean isSelected() {
    	if(isManualMode()){
        	return isManualSelected();
    	}else{
        	return isAutoSelected();
        }
    }

    @Override
    public int hashCode() {
        return this.areaImageURIPath.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof MarkAreaAnswerItem) {
            return compareTo((MarkAreaAnswerItem) o) == 0;
        } else {
            return false;
        }
    }

    public int compareTo(MarkAreaAnswerItem item) {
        double c = this.density - item.density;
        if (c < 0.0) {
            return -1;
        } else if (c > 0.0) {
            return 1;
        } else {
            return 0;
        }
    }

    public int getItemIndex() {
        return this.itemIndex;
    }

    public double getDensity() {
        return this.density;
    }

    public String getAreaImageURIPath() {
        return this.areaImageURIPath;
    }

    /*
	public String getPagePath() {
    	return pagePath;
    }

	public void setPagePath(String pagePath) {
    	this.pagePath = pagePath;
    }

	public int getPageIndex() {
    	return pageIndex;
    }

	public void setPageIndex(int pageIndex) {
    	this.pageIndex = pageIndex;
    }
    */
}