/**
 *  Answer.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/03/13
 Author hiroya
 */
package net.sqs2.omr.result;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MarkAreaAnswer extends Answer implements Serializable {
	private static final long serialVersionUID = 3L;

	protected ArrayList<MarkAreaAnswerItem> markAreaAnswerItemList = new ArrayList<MarkAreaAnswerItem>();
	protected float reliability;
	int numMarkedAnswerItems = -1;
	
	public MarkAreaAnswer() {
	}

	public boolean isNoAnswer() {
		return this.numMarkedAnswerItems == 0;
	}

	int size() {
		return this.markAreaAnswerItemList.size();
	}

	public void addMarkAreaAnswerItem(MarkAreaAnswerItem answerItem) {
		this.markAreaAnswerItemList.add(answerItem);
	}

	public MarkAreaAnswerItem getMarkAreaAnswerItem(int itemIndex) {
		return this.markAreaAnswerItemList.get(itemIndex);
	}

	public List<MarkAreaAnswerItem> getMarkAreaAnswerItemList() {
		return this.markAreaAnswerItemList;
	}
	
	public float getReliability(){
		return this.reliability;
	}
	
	public int getNumMarkedAnswerItems(){
		return this.numMarkedAnswerItems;
	}

	public void setNumMarkedAnswerItems(int numMarkedAnswerItems){
		this.numMarkedAnswerItems = numMarkedAnswerItems;
	}

	public void setReliability(float reliability){
		this.reliability = reliability;
	}

	@Override
	public String toString() {
		if (isNoAnswer()) {
			return "N/A";
		} else {
			return this.markAreaAnswerItemList.toString();
		}
	}
}