package net.sqs2.omr.result;

public abstract class ImagePathInfo {

	protected static final char SLASH = '/';
	protected static final char DASH = '-';
	protected static final char DOT = '.';

	protected String pageFilePath;
	protected int pageIndexInFile;
	protected int masterIndex;
	protected String extension;

	public ImagePathInfo(String pageFilePath, int pageIndexInFile,
			int masterIndex, String ext){
		this.pageFilePath = pageFilePath;
		this.pageIndexInFile = pageIndexInFile;
		this.masterIndex = masterIndex;
		this.extension = ext;
	}

	public abstract String toPathInfo();

	@Override
	public String toString(){
		return toPathInfo();
	}

	@Override
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		try{
			ImagePathInfo api = (ImagePathInfo)o;
			return api.masterIndex == masterIndex &&
			api.extension.equals(extension) && 
			api.pageFilePath.equals(pageFilePath);
		}catch(NullPointerException ex){
			return false; 
		}catch(ClassCastException ex){
			return false; 
		}
	}


	public String getPageFilePath() {
    	return pageFilePath;
    }

	public int getPageIndexInFile() {
    	return pageIndexInFile;
    }

	public int getMasterIndex() {
    	return masterIndex;
    }

	public String getExtension() {
    	return extension;
    }
	
}