/*

 FormAreaImageUtil.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07

 */
package net.sqs2.omr.result;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.source.PageTask;
import net.sqs2.omr.master.FormMaster;

public class ImageFileUtil {

	public static void writeFormAreaImage(FormMaster master, PageTask pageTask, byte[] data, String imageType, File formAreaFile)
	throws IOException {
		writeFormAreaImage(master, pageTask, formAreaFile, 
				data, 
				imageType);
	}

	private static void writeFormAreaImage(PageMaster master,
			PageTask pageTask, File formAreaFile, byte[] data, String imageType)
	throws IOException {
		long formAreaFileLastModified = formAreaFile.lastModified();
		if (formAreaFile.exists()
				&& pageTask.getPageID().getLastModified() < formAreaFileLastModified
				&& master.getLastModified() < formAreaFileLastModified
				&& pageTask.getPageTaskConfigLastModified() < formAreaFileLastModified) {
			// System.err.println("cancel image generation:"+textAreaFile);
			return;
		}
		if (data != null) {
			writeImage(formAreaFile, data);
		} else {
			// System.err.println("ERROR: null writeTextAreaImage:
			// "+pageTask);
		}
	}

	public static void writeImage(File outputFile, byte[] data)
	throws IOException {
		OutputStream out = null;
		try {
			out = new BufferedOutputStream(new FileOutputStream(outputFile));
			out.write(data);
		} finally {
			if (out != null) {
				try {
					out.close();
				} catch (Exception ignore) {
				}
			}
		}
	}
}
