/**
 * 
 */
package net.sqs2.omr.result;

public class AreaImagePathInfo extends ImagePathInfo{

	private int questionIndex;
	private int itemIndex;

	public AreaImagePathInfo(String sourceFilePath, int pageIndex,
			int masterIndex, int questionIndex, int itemIndex, String extension){
		super(sourceFilePath, pageIndex, masterIndex, extension);
		this.questionIndex = questionIndex;
		this.itemIndex = itemIndex;
	}

	@Override
	public String toPathInfo(){
		return toPathInfo(itemIndex);
	}

	public String toPathInfo(int itemIndex){
		return this.pageFilePath + SLASH + this.pageIndexInFile + SLASH + 
		this.masterIndex + DASH + this.questionIndex + DASH + itemIndex + DOT + this.extension;
	}

	public static AreaImagePathInfo parse(String src){
		try{
			int pExt = src.lastIndexOf(DOT);
			String ext = src.substring(pExt + 1);

			int pItemIndex = src.lastIndexOf(DASH, pExt - 1);
			int itemIndex  = Integer.parseInt(src.substring(pItemIndex + 1, pExt));

			int pQuestionIndex = src.lastIndexOf(DASH, pItemIndex - 1);
			int questionIndex  = Integer.parseInt(src.substring(pQuestionIndex + 1, pItemIndex));

			int pMasterIndex = src.lastIndexOf(SLASH, pQuestionIndex - 1);
			int masterIndex  = Integer.parseInt(src.substring(pMasterIndex + 1, pQuestionIndex));

			int pPageIndex = src.lastIndexOf(SLASH, pMasterIndex - 1);
			int pageIndex  = Integer.parseInt(src.substring(pPageIndex + 1, pMasterIndex));

			String sourceFilePath = src.substring(0, pPageIndex);

			return new AreaImagePathInfo(sourceFilePath, pageIndex, masterIndex, questionIndex, itemIndex, ext);
		}catch(NullPointerException ex){
			return null;
		}
	}
	
	@Override
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		try{
			AreaImagePathInfo api = (AreaImagePathInfo)o;
			return super.equals(api) &&
			api.questionIndex == api.questionIndex &&
			api.itemIndex == itemIndex;
		}catch(NullPointerException ex){
			return false; 
		}catch(ClassCastException ex){
			return false; 
		}
	}

	public int getQuestionIndex() {
    	return questionIndex;
    }

	public int getItemIndex() {
		return this.itemIndex;
    }

}