/*

 AnswerItemBag.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07

 */
package net.sqs2.omr.result;

import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.bag.TreeBag;

public class AnswerItemBag {
	private Bag<Integer> answerItemIndexBag = new TreeBag<Integer>();

	private static final int NO_ANSWER = -1;

	public void clear() {
		this.answerItemIndexBag.clear();
	}

	public void add(MarkAreaAnswerItem item) {
		this.answerItemIndexBag.add(item.getItemIndex());
	}

	public int getCount(int itemIndex) {
		return this.answerItemIndexBag.getCount(itemIndex);
	}

	public void addNoAnswer() {
		this.answerItemIndexBag.add(NO_ANSWER);
	}

	public int countNoAnswer() {
		return getCount(NO_ANSWER);
	}

	@Override
	public String toString(){
		return "AnswerItemBag:"+this.answerItemIndexBag;
	}

}
