/*

 AbstractResultPathUtil.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07

 */
package net.sqs2.omr.result;

import java.io.File;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.source.config.FormResultConfig;
import net.sqs2.util.FileUtil;

public abstract class AbstractResultPathFactory {

    protected File sourceDirectoryRoot;

    protected File resultDirectoryRoot;

    protected FormResultConfig formResultConfig;

    protected int mode;

    public static final char DOT = '.';
    public static final char DASH = '-';

    public AbstractResultPathFactory(File sourceDirectoryRoot,
                                     File resultDirectoryRoot, FormResultConfig resultConfig, int mode) {
        this.sourceDirectoryRoot = sourceDirectoryRoot;
        this.resultDirectoryRoot = resultDirectoryRoot;
        this.formResultConfig = resultConfig;
        this.mode = mode;
    }

    public File getSourceDirectoryRoot() {
        return this.sourceDirectoryRoot;
    }

    public File getResultDirectoryRoot() {
        return this.resultDirectoryRoot;
    }

    public FormResultConfig getFormResultConfig() {
        return this.formResultConfig;
    }

    public abstract File getResultMasterDirectory(FormMaster master);

    public abstract File getResultMasterDirectory(String masterPath, String sourceDirectoryPath);

    public abstract File getResultMasterDirectoryIndexFile(String masterPath, String sourceDirectoryPath);

    public abstract File getResultMasterPageFile(String masterPath,
                                                 String sourceDirectoryPath, PageID pageID, String ext);

    public abstract File getResultMasterColumnFile(String masterPath,
                                                   String sourceDirectoryPath, int qIndex, String ext);

    public File getResultIndexFile() {
        return new File(this.resultDirectoryRoot, "index.html");
    }

    public File getTextAreaFile(String masterPath, String sourceDirectoryPath,
                                PageID pageID, int columnIndex, String ext) {

        if (pageID.getNumPagesInFile() == 1) {
            return new File(this.resultDirectoryRoot.getAbsolutePath() + File.separatorChar +
                    FileUtil.getBasename(masterPath) + File.separatorChar +
                    pageID.getPath() + File.separatorChar +
                    columnIndex + DOT + ext);
        } else {
            return new File(this.resultDirectoryRoot.getAbsolutePath() + File.separatorChar +
                    FileUtil.getBasename(masterPath) + File.separatorChar +
                    pageID.getPath() + File.separatorChar +
                    pageID.getIndex() + File.separatorChar +
                    columnIndex + DOT + ext);
        }

    }

    public File getErrorFile(String masterPath, PageID pageID, String ext) {
        return getResultMasterPageFile(masterPath, "error", pageID, ext);
    }

    public File getChartFile(String masterPath, String sourceDirectoryPath,
                             int qIndex, String ext) {
        return getResultMasterColumnFile(masterPath, sourceDirectoryPath,
                qIndex, ext);
    }

    public File getMatrixFile(String masterPath, String sourceDirectoryPath,
                              String ext) {
        return new File(FileUtil.getBasepath(getResultMasterDirectoryIndexFile(masterPath, sourceDirectoryPath)) + DOT + ext);
    }

    public File getColumnFile(String masterPath, String sourceDirectoryPath, int columnIndex, String suffix) {
        File resultMasterDirectory = getResultMasterDirectory(masterPath, sourceDirectoryPath);
        return new File(resultMasterDirectory.getAbsolutePath() + File.separatorChar + columnIndex + suffix + ".html");
    }

}