/*

 PDFBookmarkFormMasterBuilder.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2006/07/10

 */
package net.sqs2.omr.master.pdfbookmark;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import net.sqs2.xml.XMLUtil;
import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.master.PageMasterFactory;
import net.sqs2.exigrid.master.PageMasterException;
import net.sqs2.exigrid.master.PageMasterFileException;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.translator.TranslatorException;
import net.sqs2.util.FileResource;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;


public class PDFBookmarkFormMasterFactory implements PageMasterFactory {

	static PageMasterFactory createInstance(){
		return new PDFBookmarkFormMasterFactory();
	}

	public FormMaster create(int masterIndex, File sourceDirectoryRoot, String path) throws PageMasterException {
		try {
			long lastModified;
			File file = new File(sourceDirectoryRoot, path);
			lastModified = file.lastModified();
			FormMaster master = new FormMaster(masterIndex, new FileResource(path, lastModified));
			Document document = createDocument(master, file);
			NodeList areaMasterElementList = document.getDocumentElement().getElementsByTagName(OMRMasterConstants.SVG_G_ELEMENT_REPRESENTATION);

			int prevPage = -1;
			String prevQID = null;

			for (int pageIndex = 0; pageIndex < master.getNumPages() ; pageIndex++ ){
				master.addFormAreaList(new ArrayList<FormArea>());
			}

			int itemIndex = 0;
			int areaLength = areaMasterElementList.getLength();
			int areaIndexInPage = 0;

			for (int areaIndex = 0; areaIndex < areaLength; areaIndex++) {

				Element gElem = (Element)areaMasterElementList.item(areaIndex);			    
				FormArea area = FormAreaFactory.create(gElem);
				if(area == null){
					throw new PageMasterFileException(file);
				}
				List<FormArea> areaListByPageIndex = getAreaListByPageIndex(master, area.getPageIndex());
				List<FormArea> areaListByQID = getAreaListByQID(master, area.getQID());

				areaListByPageIndex.add(area);
				areaListByQID.add(area);

				master.getFormAreaList().add(area);
				master.putFormArea(area.getID(), area);
				master.setAreaIndexInPage(area.getQID(), areaIndexInPage);

				//System.err.println(area.getID()+"-> "+area.getPage()+"   "+area.getQID()+" - "+areaIndexInPage);

				if (prevPage == area.getPage()) {
					areaIndexInPage++;
				}else{
					areaIndexInPage = 0;
				}			    
				if (area.getQID().equals(prevQID)) {
					itemIndex++;
				}else{
					master.addQID(area.getQID());
					itemIndex = 0;
				}
				area.setIndex(itemIndex, areaIndexInPage);
				prevQID = area.getQID();
				prevPage = area.getPage();
			}
			//master.setNumColumns(numColumns);
			master.setCorners(getMasterGuideCorners(document));
			master.setFooterLeftRectangle(new Rectangle(31, 788, 24, 11));
			master.setFooterRightRectangle(new Rectangle(554, 788, 24, 11));
			master.setHeaderCheckArea(new Rectangle(308, 19, 76, 19));
			master.setFooterCheckArea(new Rectangle(308, 801, 76, 19));
			Logger.getLogger("master").log(Level.INFO, master.getPath());
			return master;
		} catch (TransformerException e) {
			throw new PageMasterException("invalid format:"+path);
		}
	}

	private Document createDocument(PageMaster master, File file) throws PageMasterException {
		FileInputStream inputStream = null;
		try {
			PDFBookmarkToSQMTranslator translator = new PDFBookmarkToSQMTranslator();
			inputStream = new FileInputStream(file);
			Document doc = XMLUtil.createDocumentBuilder().parse(translator.translate(inputStream, file.toURI().toString()));
			master.setNumPages(translator.getNumPages());
			return doc;
		} catch (SAXException ex) {
			throw new PageMasterException(ex);
		} catch (IOException ex) {
			throw new PageMasterException(ex);
		} catch (TranslatorException ex) {
			throw new PageMasterException(ex);
		} catch (FactoryConfigurationError ex) {
			throw new RuntimeException(ex);
		} catch (ParserConfigurationException ex) {
			throw new RuntimeException(ex);
		}finally{
			try{
				inputStream.close();
			}catch(Exception ignore){}
		}
	}

	private ArrayList<FormArea> getAreaListByPageIndex(FormMaster master, int pageIndex) {
		return master.getFormAreaListByPageIndex(pageIndex);        
	}

	private ArrayList<FormArea> getAreaListByQID(FormMaster master, String qid) {
		ArrayList<FormArea> areaList = master.getFormAreaList(qid);
		if (areaList == null) {
			areaList = new ArrayList<FormArea>();
			master.putFormAreaList(qid, areaList);
		}
		return areaList;
	}

	private Point[] getMasterGuideCorners(Document document) throws PageMasterException{
		try{
			Element pageElem = (Element)XPathAPI.selectSingleNode(document.getDocumentElement(), OMRMasterConstants.METADATA_PAGE_ELEMENT_REPRESENTATION);
			Point[] ret = new Point[4];
			for (int i = 0; i < 4; i++) {
				ret[i] = createPoint(pageElem, i + 1);
			}
			return ret;
		}catch(TransformerException ex){
			ex.printStackTrace();
			throw new PageMasterException(ex);
		}
	}

	private static Point createPoint(Element elem, int n) {
		return new Point(Integer.parseInt(elem.getAttribute(OMRMasterConstants.X_ATTRIBUTE + n)), Integer.parseInt(elem.getAttribute(OMRMasterConstants.Y_ATTRIBUTE + n)));
	}

}
