/**
 *  OMRMasterConstants.java
 
 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).
 
 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at
 
 http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 
 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.master.pdfattachment;

import net.sqs2.xmlns.SQSNamespaces;

public interface OMRMasterConstants{
    public static final String SVG_G_ELEMENT_REPRESENTATION = "svg:g";
    public static final String METADATA_PAGE_ELEMENT_REPRESENTATION = "/svg:svg/svg:pageSet/svg:masterPage/svg:metadata/master:page";
    public static final String METADATA_STAR_ELEMENT_REPRESENTATION = "svg:rect/svg:metadata/*";
    public static final String RECT_METADATA_STAR_HINT_ELEMENT_REPRESENTATION = "svg:rect/svg:metadata/*/xforms:hint";
    public static final String NUMPAGES_ATTRIBUTE_REPRESENTATION = "numPages";   
    public static final String RECT_ELEMENT_REPRESENTATION = "svg:rect";
    
    public static final String X_ATTRIBUTE = "x";
    public static final String Y_ATTRIBUTE = "y";
    
    public static final String[][] LABEL_PATH = {
        { SQSNamespaces.XFORMS_URI, "item" },
        { SQSNamespaces.XFORMS_URI, "label" } };

    public static final String[][] VALUE_PATH = {
        { SQSNamespaces.XFORMS_URI, "item" },
        { SQSNamespaces.XFORMS_URI, "value" } };
    

}
