/**
 *  FormMasterFactory.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/07/31
 Author hiroya
 */

package net.sqs2.omr.master;

import java.io.File;
import java.util.logging.Logger;

import net.sqs2.exigrid.master.PageMaster;
import net.sqs2.exigrid.master.PageMasterException;
import net.sqs2.exigrid.master.PageMasterFactory;
import net.sqs2.omr.master.pdfattachment.PDFAttachmentFormMasterFactory;
import net.sqs2.omr.master.pdfbookmark.PDFBookmarkFormMasterFactory;

public class FormMasterFactory implements PageMasterFactory{
	
	PageMasterFactory[] pageMasterFactoryArray = new PageMasterFactory[]{
			new PDFAttachmentFormMasterFactory(),
			new PDFBookmarkFormMasterFactory()
	};
	
	public PageMaster create(int masterIndex, File sourceDirectoryRoot, String path) throws PageMasterException{
		for(PageMasterFactory formMasterFactory : this.pageMasterFactoryArray){
			try{
				return formMasterFactory.create(masterIndex, sourceDirectoryRoot, path);
			}catch(PageMasterException ex){
				Logger.getAnonymousLogger().warning(ex.getMessage());
			}catch(Exception ex){
				ex.printStackTrace();
			}
		}
		throw new PageMasterException("invalid master file");
	}
}
