/**
 *  SessionDirFileContentServlet.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/08/29
 Author hiroya
 */

package net.sqs2.omr.httpd;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.util.FileUtil;

public class SessionDirFileContentServlet extends HttpServlet {

	private static final long serialVersionUID = 0L;
	//private RowAccessor rowAccessor = new RowAccessor();

	public static String getContextString(){
		return "session";
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		String pathInfo = req.getPathInfo().substring(1);
		SessionSource source = getSessionSource();
		File sourceDirectoryRoot = source.getSourceDirectoryRoot();
		File resultDirectoryRoot = source.getResultDirectoryRoot();
		File pathTranslated = getPathTranslated(pathInfo, sourceDirectoryRoot, resultDirectoryRoot);
		if(pathTranslated == null){
			return;
		}
		if(pathTranslated.isDirectory()){
			pathTranslated = new File(pathTranslated.getAbsolutePath()+File.separatorChar+"index.html");
		}
		if(pathTranslated.canRead()){
			FileUtil.pipe(new FileInputStream(pathTranslated), res.getOutputStream());
		}
	}
	
	private File getPathTranslated(String pathInfo, File sourceDirectoryRoot, File resultDirectoryRoot) throws ServletException, UnsupportedEncodingException {
		int pos = pathInfo.indexOf('/');
		String key = null;
		String value = null;
		if(pos <= 0){
			key = pathInfo;
			value = "";
		}else{
			key = pathInfo.substring(0, pos);
			value = pathInfo.substring(pos+1);
		}
		File target = null;
		if(sourceDirectoryRoot.getName().equals(key)){
			target = sourceDirectoryRoot;
		}else if(resultDirectoryRoot.getName().equals(key)){
			target = resultDirectoryRoot;
		}else{
			return null;
		}
		String enc = (File.separatorChar == '/')? "UTF-8":"ms932";
		String decodedValue = URLDecoder.decode(value, enc);
		return new File(target.getAbsolutePath()+File.separatorChar+decodedValue);
	}

	protected static SessionSource getSessionSource(){
		return SessionSource.getInstance();
	}

	private static File getTargetDirectory(File file, File sourceDirectoryRoot, File resultDirectoryRoot) {
		boolean isSourcePathStart = file.getAbsolutePath().startsWith(sourceDirectoryRoot.getAbsolutePath());
		boolean isResultPathStart = file.getAbsolutePath().startsWith(resultDirectoryRoot.getAbsolutePath());

		if(isSourcePathStart && isResultPathStart){
			if(sourceDirectoryRoot.getAbsolutePath().length() <= resultDirectoryRoot.getAbsolutePath().length()){
				return resultDirectoryRoot;
			}else{
				return sourceDirectoryRoot;
			}
		}else{
			if(isSourcePathStart){
				return sourceDirectoryRoot;
			}
			if(isResultPathStart){
				return resultDirectoryRoot;
			}
		}
		return null;
	}

	public static String getPathInfo(File file){
		SessionSource sessionSource = getSessionSource();
		File targetDirectory = getTargetDirectory(file, sessionSource.getSourceDirectoryRoot(), sessionSource.getResultDirectoryRoot());
		return "/"+getContextString()+"/"+targetDirectory.getName()+"/"+file.getAbsolutePath().substring(targetDirectory.getAbsolutePath().length());
	}

}
