package net.sqs2.omr.httpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.page.PageSource;
import net.sqs2.omr.result.RectImagePathInfo;
import net.sqs2.util.FileUtil;

public class RectImageContentServlet extends ImageContentServlet {

	private static final long serialVersionUID = 0L;
	
	public RectImageContentServlet() throws ServletException{
		super();
	}
	
	public static String getContextString(){
		return "r";
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		RectImagePathInfo rpi = RectImagePathInfo.parse(req.getPathInfo().substring(1));
		SessionSource source = SessionDirFileContentServlet.getSessionSource();
		FormMaster formMaster = (FormMaster)source.getPageMaster(rpi.getMasterIndex());
		int pageNumber = rpi.getPageIndex();
		PageSource pageSource = getPageSource(rpi, pageNumber, source, formMaster);
		byte[] bytes = createImageBytes(pageSource, rpi.getRectangle());
		FileUtil.pipe(new ByteArrayInputStream(bytes), res.getOutputStream());
	}
}
