package net.sqs2.omr.httpd;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;

import net.sqs2.exigrid.source.PageID;
import net.sqs2.exigrid.source.PageTaskAccessor;
import net.sqs2.exigrid.source.PageTaskImpl;
import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.image.ImageFactory;
import net.sqs2.omr.execute.SessionExecutorCoreImpl;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.page.PageSource;
import net.sqs2.omr.result.ImagePathInfo;

import org.apache.commons.collections15.map.LRUMap;

public abstract class ImageContentServlet extends HttpServlet {

	private static final long serialVersionUID = 0L;
	protected LRUMap<String, PageSource> cachedPageSources = new LRUMap<String, PageSource>(4){
		private static final long serialVersionUID = 0L;
		protected boolean removeLRU(LinkEntry<String,PageSource> entry) {
			//	release resources held by entry
			entry.getValue().flush();
			return true;  // actually delete entry
		}
	};

	public static String getContextString(){
		return "i";
	}

	public ImageContentServlet() throws ServletException{
		super();
	}
	
	protected synchronized PageSource getPageSource(ImagePathInfo api, int pageNumber,
			SessionSource source, 
			FormMaster formMaster) throws IOException {
		File sourceDirectoryRoot = source.getSourceDirectoryRoot();
		File pageFile = new File(sourceDirectoryRoot, api.getPageFilePath());
		String pageTaskID = PageTaskImpl.createID(formMaster.getFileResource(), pageNumber, 
				new PageID(api.getPageFilePath(), pageFile.lastModified(), api.getPageIndexInFile(), ImageFactory.getNumPages(pageFile)));

		PageTaskAccessor accessor = new PageTaskAccessor(sourceDirectoryRoot, source.getResultDirectoryRoot());
		
		PageSource pageSource = this.cachedPageSources.get(pageTaskID);
		if(pageSource == null){
			String pageFilePath = sourceDirectoryRoot+File.separator+api.getPageFilePath();
			BufferedImage pageImage = ImageFactory.createImage(pageFilePath);
			pageSource = new PageSource(pageImage, formMaster.getCorners(),
					accessor.get(pageTaskID).getPageTaskResult().getCorners(),
			1.0f,
			SessionExecutorCoreImpl.DEFAULT_BLACK_WHITE_THRESHOLD);
			this.cachedPageSources.put(pageTaskID, pageSource);
			System.err.println("+"+pageTaskID);
		}else{
			System.err.println("="+pageTaskID);
		}
		return pageSource;
	}

	protected byte[] createImageBytes(PageSource pageSource, Rectangle rectangle) throws IOException {
		BufferedImage formAreaImage = pageSource.cropImage(SessionExecutorCoreImpl.getPreviewMarginRect(rectangle));
		byte[] bytes = ImageFactory.writeImage(formAreaImage, "jpeg");
		formAreaImage.flush();
		return bytes;
	}

}