package net.sqs2.omr.httpd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections15.map.LRUMap;

import net.sqs2.exigrid.source.SessionSource;
import net.sqs2.omr.master.FormArea;
import net.sqs2.omr.master.FormMaster;
import net.sqs2.omr.page.PageSource;
import net.sqs2.omr.result.AreaImagePathInfo;
import net.sqs2.util.FileUtil;

public class AreaImageContentServlet extends ImageContentServlet {

	private static final long serialVersionUID = 0L;
	private LRUMap<String,byte[]> areaImageBytesCache = new LRUMap<String,byte[]>(128);
	public AreaImageContentServlet() throws ServletException{
		super();
	}

	public static String getContextString(){
		return "a";
	}

	@Override
	protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
		String pathInfo = req.getPathInfo().substring(1);
		byte[] bytes = getItemImageBytes(pathInfo);
		FileUtil.pipe(new ByteArrayInputStream(bytes), res.getOutputStream());
	}

	private byte[] getItemImageBytes(String pathInfo) throws IOException {
	    synchronized(areaImageBytesCache){
			byte[] bytes = areaImageBytesCache.get(pathInfo);
			if(bytes == null){
				AreaImagePathInfo api = AreaImagePathInfo.parse(pathInfo);
				SessionSource source = SessionDirFileContentServlet.getSessionSource();
				FormMaster formMaster = (FormMaster)source.getPageMaster(api.getMasterIndex());
				int pageNumber = formMaster.getFormAreaList(api.getQuestionIndex()).get(api.getItemIndex()).getPage();
				PageSource pageSource = getPageSource(api, pageNumber, source, formMaster);
				List<FormArea> formAreaList = formMaster.getFormAreaList(api.getQuestionIndex());
				for(int i = 0; i < formAreaList.size(); i++){
					byte[] itemImageBytes = createImageBytes(pageSource, formAreaList.get(i).getRect());
					areaImageBytesCache.put(api.toPathInfo(i), itemImageBytes);
					if(i == api.getItemIndex()){
						bytes = itemImageBytes;
					}
				}
			}
			return bytes;
		}
    }

}
