/*

 PageOrderExceptionCore.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on Apr 7, 2007

 */
package net.sqs2.omr.execute.page;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;

public class PageSequenceInvalidExceptionCore extends PageFrameExceptionCore implements Serializable {
	final static private long serialVersionUID = 0L;

	Rectangle leftFooterArea, rightFooterArea;
	int leftValue, rightValue;

	public PageSequenceInvalidExceptionCore(int width, int height, Point[] masterGuide, Point[] corners,
	        Rectangle footerAreaLeft, int left, Rectangle footerAreaRight,
	        int right) {
		super(width, height, masterGuide, corners);
		this.leftFooterArea = footerAreaLeft;
		this.rightFooterArea = footerAreaRight;
		this.leftValue = left;
		this.rightValue = right;
	}

	public Rectangle getLeftFooterArea() {
    	return leftFooterArea;
    }

	public Rectangle getRightFooterArea() {
    	return rightFooterArea;
    }

	public int getLeftValue() {
		return leftValue;
	}

	public int getRightValue() {
		return rightValue;
	}

	@Override
	public String getDescription() {
		return "check page order: (" + leftFooterArea + "=" + leftValue
		        + ", " + rightFooterArea + "=" + rightValue + ")";
	}
}
