/*

 PageFrameInvalidException.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2006/01/02

 */
package net.sqs2.omr.execute.page;

import java.awt.Point;
import java.io.Serializable;
//import java.text.DecimalFormat;


public class PageFrameDistortionExceptionCore extends PageFrameExceptionCore implements Serializable {
	public static final long serialVersionUID = 0L;

	public static final int UNDEFINED = 0;

	public static final int HORIZONTAL = 1;

	public static final int VERTICAL = 2;

	public PageFrameDistortionExceptionCore(int width, int height, Point[] masterCorners, Point[] corners) {
		super(width, height, masterCorners, corners);
	}

	private String toString(Point corner) {
		if (corner != null) {
			return "(" + (int) corner.getX() + "," + (int) corner.getY() + ")";
		} else {
			return "(error)";
		}
	}

	public String getDescription() {
		return "Header[" + toString(this.corners[0])
			+ toString(this.corners[1]) + "]  " + "Footer["
			+ toString(this.corners[2]) + toString(this.corners[3]) + "]";
	}
}
