package net.sqs2.omr.execute.page;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.security.InvalidParameterException;

import net.sqs2.image.ImageUtil;

public class BlockCenterPointExtract {
	
	Point blockCenterPoint = null;
	//List<Point> blockCenterPointList = null;
	
	private static final float BLOCK_RECOGNITION_HORIZONTAL_RATIO = 0.5f; 
	private static final float BLOCK_RECOGNITION_VERTICAL_RATIO = 0.5f;
	private static final float BLACK_THRESHOLD_RATIO = 0.9f;

	public BlockCenterPointExtract(BufferedImage image, Rectangle focusArea){
		this.blockCenterPoint = createBlockCenterPoint(image, focusArea);
	}

	/*
	public BlockCenterPointExtract(BufferedImage image, List<Rectangle> focusAreaList){
		this(image, focusAreaList, null);
	}

	public BlockCenterPointExtract(BufferedImage image, List<Rectangle> focusAreaList,
			List<Point> blockCenterPointList){

		if(blockCenterPointList == null){
			this.blockCenterPointList = new ArrayList<Point>(focusAreaList.size()); 	
		}else{
			this.blockCenterPointList = blockCenterPointList; 
		}
		
		for(int index = 0; index < focusAreaList.size(); index++){
			Rectangle focusArea = focusAreaList.get(index);
			Point centerPoint = null;
			if(blockCenterPointList != null){
				centerPoint = blockCenterPointList.get(index);
			}
			this.blockCenterPointList.add(createBlockCenterPoint(image, focusArea,
					centerPoint));
		}
	}
	*/
	
	public Point getBlockCenterPoint(){
		return this.blockCenterPoint;
	}
	
	/*
	public List<Point> getBlockCenterPointList(){
		return this.blockCenterPointList;
	}
	*/
	
	private static Point createBlockCenterPoint(BufferedImage image, Rectangle focusArea){
		return createBlockCenterPoint(image, focusArea, null);
	}
	
	private static Point createBlockCenterPoint(BufferedImage image, Rectangle focusArea,
			Point centerPoint){
		
		if(centerPoint == null){
			centerPoint = new Point(focusArea.x + focusArea.width / 2,
					focusArea.y + focusArea.height / 2);
		}else if(focusArea.contains(centerPoint)){
			throw new InvalidParameterException(centerPoint.toString());
		}
		
		int firstBlackVerticalLineX = scanEdge(image,
				focusArea, centerPoint, -1, 0);
		int lastBlackVerticalLineX = scanEdge(image,
				focusArea, centerPoint, 1, 0);
		int firstBlackHorizontalLineY = scanEdge(image,
				focusArea, centerPoint, 0, -1);
		int lastBlackHorizontalLineY = scanEdge(image,
				focusArea, centerPoint, 0, 1);
		
		return new Point((firstBlackVerticalLineX + lastBlackVerticalLineX) / 2,
				(firstBlackHorizontalLineY + lastBlackHorizontalLineY) / 2);
	}
	
	private static int countNumBlackPixelsHorizontal(BufferedImage image, 
			Rectangle focusArea, int y){
		int numBlackHorizontalPixels = 0;
		for(int x = focusArea.x; x < focusArea.x + focusArea.width; x++){
			if(ImageUtil.rgb2gray(image.getRGB(x, y)) <= 255 * BLACK_THRESHOLD_RATIO){
				numBlackHorizontalPixels++;	
			}
		}
		return numBlackHorizontalPixels;
	}
	
	private static int countNumBlackPixelsVertical(BufferedImage image, 
			Rectangle focusArea, int x){
		int numBlackVerticalPixels = 0;
		for(int y = focusArea.y; y < focusArea.y + focusArea.height; y++){
			if(ImageUtil.rgb2gray(image.getRGB(x, y)) <= 255 * BLACK_THRESHOLD_RATIO){
				numBlackVerticalPixels++;	
			}
		}
		return numBlackVerticalPixels;
	}
	
	private static int scanEdge(BufferedImage image,
			Rectangle focusArea, 
			Point start, int dx, int dy){
		
		if(dx == 0 && dy == -1){
			for(int y = start.y; focusArea.y <= y; y--){
				int numBlackHorizontalPixels = countNumBlackPixelsHorizontal(image, focusArea, y);
				if(numBlackHorizontalPixels < focusArea.width * BLOCK_RECOGNITION_HORIZONTAL_RATIO){
					return y;
				}
			}
			return focusArea.y;
		}else if(dx == 0 && dy == 1){
			for(int y = start.y; y < focusArea.y + focusArea.height; y++){
				int numBlackHorizontalPixels = countNumBlackPixelsHorizontal(image, focusArea, y);
				if(numBlackHorizontalPixels < focusArea.width * BLOCK_RECOGNITION_HORIZONTAL_RATIO){
					return y;
				}
			}
			return focusArea.y + focusArea.height - 1;
		}else if(dx == -1 && dy == 0){
			for(int x = start.x; focusArea.x <= x; x--){
				int numBlackVerticalPixels = countNumBlackPixelsVertical(image, focusArea, x);
				if(numBlackVerticalPixels < focusArea.height * BLOCK_RECOGNITION_VERTICAL_RATIO){
					return x;
				}
			}
			return focusArea.x;
		}else if(dx == 1 && dy == 0){
			for(int x = start.x; x < focusArea.x + focusArea.width; x++){
				int numBlackVerticalPixels = countNumBlackPixelsVertical(image, focusArea, x);
				if(numBlackVerticalPixels < focusArea.height * BLOCK_RECOGNITION_VERTICAL_RATIO){
					return x;
				}
			}
			return focusArea.x + focusArea.width - 1;
		}else{
			throw new InvalidParameterException("dx="+dx+",dy="+dy);
		}
	}
}
