/*

 EngineLauncher.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on Apr 7, 2007

 */
package net.sqs2.omr.engine;

import java.io.File;
import java.net.URL;

import net.sqs2.exigrid.engine.ExigridConstants;
import net.sqs2.net.ClassURLStreamHandlerFactory;


public class MarkReaderEngineLauncher {

	public static void main(String[] args)throws Exception{
		if(args.length < 1){
			System.err.println("Usage: MarkReaderEngineLauncher <sourceDirectoryRoot>");
			return;
		}
		try{
			URL.setURLStreamHandlerFactory(new ClassURLStreamHandlerFactory());
		}catch(Error ignore){}

		//String uploadSiteURI = args[1];
		File sourceDirectoryRoot = new File(args[0]);
		File resultDirectoryRoot = new File(sourceDirectoryRoot+ExigridConstants.RESULT_FOLDER_SUFFIX);
		new MarkReaderEngineFactory().create(1099).start(sourceDirectoryRoot, resultDirectoryRoot, true);
	}

}
