/*

 SessionProgressPanel.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/2/11

 */
package net.sqs2.exigrid.swing;

import java.util.Observable;
import java.util.Observer;

import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SessionProgressPanel extends JPanel implements Observer{
	private static final long serialVersionUID = 0L;

	protected SessionProgressModel model;

	public SessionProgressPanel(){
	}

	public SessionProgressPanel(SessionProgressModel model) {
		super();
		this.model = model;
		this.model.addObserver(this);
	}

	public void update() {
		update(null, null);
	}

	boolean nowUpdating = false;

	public synchronized void update(final Observable src, final Object value) {
		if(this.nowUpdating){
			return;
		}
		SwingUtilities.invokeLater(new Runnable(){
			public void run(){
				nowUpdating = true;
				repaint();
				nowUpdating = false;
			}
		});
	}

}