/*

 SessionProgressMeter.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2006/01/10

 */
package net.sqs2.exigrid.swing;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.io.File;
import java.util.Observable;

import javax.swing.JOptionPane;

import org.mortbay.util.URIUtil;

import net.sqs2.browser.Browser;
import net.sqs2.omr.httpd.SQSHttpdManager;

public class SessionProgressMeter extends SessionProgressPanel{
	private static final long serialVersionUID = 0L;

	int numRemoteClients;

	private static Stroke DASHED_STROKE1 = new BasicStroke(1.0f, BasicStroke.CAP_BUTT,
			BasicStroke.JOIN_MITER, 10.0f, new float[]{2.0f, 1.0f}, 0.0f);
	private static Stroke DASHED_STROKE2 = new BasicStroke(1.0f, BasicStroke.CAP_BUTT,
			BasicStroke.JOIN_MITER, 10.0f, new float[]{1.0f, 1.0f}, 0.0f);


	public SessionProgressMeter(SessionProgressModel model){
		super(model);
	}

	@Override
	public synchronized void update(Observable src, Object value) {
		super.update(src, value);
		if(this.model.checkFinishedMessage()){
			if(JOptionPane.showConfirmDialog(this, "Session finished.\nBrowse result?", "Session Finished",
					JOptionPane.OK_CANCEL_OPTION, 
					JOptionPane.INFORMATION_MESSAGE) == JOptionPane.OK_OPTION){
				browseFile(this.model.getResultDirectoryRoot());
			}
		}
	}
	
	private String createURL(File file) throws Exception {
		String url = URIUtil.encodePath(SQSHttpdManager.getEXIgridHttpd().createSessionURL(file).toString());
		return url;
	}

	private void browseFile(File file) {
		try {
			String url = createURL(file);
			Browser.showDocument(url);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

	public void paintComponent(Graphics g){
		super.paintComponent(g);
		if(this.model == null){
			return; 
		}
		setPreferredSize(new Dimension(200,120));
		Dimension size = getSize();
		int width = (int)size.getWidth();
		int height = (int)size.getHeight();
		int fieldHeight = height / this.model.COLORS.length;
		int fontSize = 12;
		int fieldWidth = 60;
		int i = 0;

		g.setColor(getBackground());
		g.fillRect(0, 0, width, height);

		for(Color color: this.model.COLORS){
			g.setColor(color);
			g.fillRect(fieldWidth - 2 , fieldHeight*(i+1)-fontSize, fontSize-1, fontSize-1);
			g.setColor(Color.BLACK);
			g.drawRect(fieldWidth - 2, fieldHeight*(i+1)-fontSize, fontSize-1, fontSize-1);
			i++;
		}

		g.setColor(Color.BLACK);

		g.drawString("Total", fieldWidth + fontSize, fieldHeight*1);

		g.drawLine(fontSize - 3 , fieldHeight*3/2-fontSize/2, fieldWidth*3-fontSize, fieldHeight*3/2-fontSize/2);

		g.drawString("Reused", fieldWidth + fontSize, fieldHeight*2);

		g.drawString("Prepared", fieldWidth + fontSize, fieldHeight*3);

		g.drawString("LeasedLocal", fieldWidth + fontSize, fieldHeight*4);		
		g.drawString("LeasedRemote", fieldWidth + fontSize, fieldHeight*5);
		g.drawString("Submitted", fieldWidth + fontSize, fieldHeight*6);
		g.drawString("Error", fieldWidth + fontSize, fieldHeight*7);
		g.drawString("Externalized", fieldWidth + fontSize, fieldHeight*8);

		if(this.model.getNumTotalPages() != 0){
			g.drawString(Integer.toString(this.model.getNumTotalPages()), fontSize, fieldHeight*1);
		}else{
			g.drawString("-", fontSize, fieldHeight*1);
		}
		if(this.model.getNumReusedPages() != 0){
			g.drawString(Integer.toString(this.model.getNumReusedPages()), fontSize, fieldHeight*2);
		}else{
			g.drawString("-", fontSize, fieldHeight*2);
		}
		g.drawString(Integer.toString(this.model.getNumPreparedPages()), fontSize, fieldHeight*3);		
		g.drawString(Integer.toString(this.model.getNumLocalLeasedPages()), fontSize, fieldHeight*4);
		g.drawString(Integer.toString(this.model.getNumRemoteLeasedPages()), fontSize, fieldHeight*5);
		g.drawString(Integer.toString(this.model.getNumSubmittedPages()), fontSize, fieldHeight*6);
		g.drawString(Integer.toString(this.model.getNumErrorPages()), fontSize, fieldHeight*7);
		g.drawString(Integer.toString(this.model.getNumExternalizedPages()), fontSize, fieldHeight*8);



		if(this.model.getTimeElapsedString() != null){
			g.drawString(" TimeElapsed: " + this.model.getTimeElapsedString()+" sec", fieldWidth*3, fieldHeight*1);
		}

		if(this.model.getPageParSecString() != null){
			g.drawString("         Rate: "+ this.model.getPageParSecString()+" pages/sec", fieldWidth*3, fieldHeight*2);
		}

		if(this.model.getTimeRemainsString() != null){
			g.drawString("  TimeRemains: "+ this.model.getTimeRemainsString()+" sec" , fieldWidth*3, fieldHeight*3);
		}



		((Graphics2D)g).setStroke(SessionProgressMeter.DASHED_STROKE1);
		g.drawLine(fontSize - 3 , fieldHeight*5/2-fontSize/2, fieldWidth*3-fontSize, fieldHeight*5/2-fontSize/2);
		((Graphics2D)g).setStroke(SessionProgressMeter.DASHED_STROKE2);
		g.drawLine(fontSize - 3 , fieldHeight*7/2-fontSize/2, fieldWidth*3-fontSize, fieldHeight*7/2-fontSize/2);
		g.drawLine(fontSize - 3 , fieldHeight*13/2-fontSize/2, fieldWidth*3-fontSize, fieldHeight*13/2-fontSize/2);

	}

	public void setNumRemoteClient(int numRemoteClients){
		this.numRemoteClients = numRemoteClients;
	}

}
