/**
 *  ExigridMenuBar.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/29
 Author hiroya
 */
package net.sqs2.exigrid.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.net.MalformedURLException;
import java.net.URL;

import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

import net.sqs2.exigrid.engine.ExigridConstants;
import net.sqs2.exigrid.engine.ExigridEngine;
import net.sqs2.swing.DocumentDialogModel;
import net.sqs2.swing.HelpMenu;
import net.sqs2.swing.MessageDialogModel;

class ExigridMenuBar extends JMenuBar{
	static private final long serialVersionUID = 0L;	

	ExigridFrame frame;
	JMenuItem openMenuItem;

	ExigridMenuBar(ExigridFrame frame){
		this.frame = frame;
		JMenu fileMenu = createFileMenu();
		JMenu configMenu = createConfigMenu();
		JMenu helpMenu = createHelpMenu();
		add(fileMenu);
		add(configMenu);
		add(helpMenu);
	}
	
	private JMenu createFileMenu() {
		JMenu fileMenu = new JMenu("File");

		fileMenu.getAccessibleContext().setAccessibleDescription("File Menu");
		this.openMenuItem = new JMenuItem("Open...", KeyEvent.VK_O);
		JMenuItem exitMenuItem = new JMenuItem("Quit", KeyEvent.VK_Q);		
		this.openMenuItem.addActionListener(new OpenMenuActionListener());
		this.openMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_O, ActionEvent.CTRL_MASK));
		exitMenuItem.addActionListener(new ExitMenuActionListener());
		exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_Q, ActionEvent.CTRL_MASK));

		fileMenu.setMnemonic(KeyEvent.VK_F);
		fileMenu.add(this.openMenuItem);
		fileMenu.addSeparator();
		fileMenu.add(exitMenuItem);

		return fileMenu;
	}

	private class OpenMenuActionListener implements ActionListener{
		public void actionPerformed(ActionEvent ev){
			frame.directoryChooserPanel.showChooserDialog();
		}
	}

	private class ExitMenuActionListener implements ActionListener{
		public void actionPerformed(ActionEvent ev){
			frame.exitConfirmation();
		}
	}

	private JMenu createConfigMenu(){
		JMenu configMenu = new JMenu("Config");
		configMenu.setMnemonic(KeyEvent.VK_C);
		JMenuItem configMenuItem = new JMenuItem("Config...");
		configMenuItem.addActionListener(new ConfigMenuActionListener());
		configMenuItem.setEnabled(false);
		configMenu.add(configMenuItem);
		return configMenu;
	}

	static class ConfigMenuActionListener implements ActionListener{
		public void actionPerformed(ActionEvent ev){
			// TODO: create config window
		}
	}

	private JMenu createHelpMenu(){
		return new ExigridHelpMenu(frame, ExigridEngine.getBaseURI());
	}
	
	public class ExigridHelpMenu extends HelpMenu{
		private static final long serialVersionUID = 0L;
		
		ExigridHelpMenu(JFrame frame, String baseURL){
				super(frame, 
					new MessageDialogModel(new String[]{
							"Exigrid", //Constants.RELEASE_ID
							"Build "+ExigridConstants.BUILD_ID,
							ExigridConstants.COPYRIGHT_NOTICE,
							"\n",
							"Licensed under the Apache License, Version 2.0 (the \"License\");",
							"you may not use this file except in compliance with the License.",
							"You may obtain a copy of the License at",
							"\n",
							"   http://www.apache.org/licenses/LICENSE-2.0",
							"\n",
							"Unless required by applicable law or agreed to in writing, software",
							"distributed under the License is distributed on an \"AS IS\" BASIS,",
							"WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.",
							"See the License for the specific language governing permissions and",
						"limitations under the License."}
					),
					new DocumentDialogModel(createURL("doc/about.html", baseURL), "license term", 640, 480));
		}		
	}
	
	static URL createURL(String href, String baseURL){
		try{			
			return new URL(baseURL+href);
		}catch(MalformedURLException ex){
			throw new RuntimeException(ex);
		}
	}

}