/**
 *  ExigridFrame.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/29
 Author hiroya
 */
package net.sqs2.exigrid.swing;

import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.io.File;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

import net.sqs2.swing.DirectoryChooserPanel;
import net.sqs2.swing.FileDropTargetDecorator;

public class ExigridFrame extends JFrame{
	static private final long serialVersionUID = 0L;

	private final ExigridLauncher launcher;

	SessionProgressModel model;

	ExigridMenuBar menuBar;
	JButton startButton;
	JButton stopButton;
	DirectoryChooserPanel directoryChooserPanel;
	SessionProgressBar progressBar;

	ExigridFrame(ExigridLauncher launcher){
		this.launcher = launcher;
	}
	
	void initialize(SessionProgressModel model, File sourceDirectoryRoot){
		this.model = model;
		this.setTitle(this.launcher.getTitle());		
		this.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
		this.menuBar = new ExigridMenuBar(this);
		this.setJMenuBar(menuBar);
		add(createPanel(sourceDirectoryRoot));
	}

	private JPanel createPanel(File sourceDirectoryRoot){
		SessionProgressMeter progressMeter = createProgressMeter();
		this.directoryChooserPanel = createDirectoryChooserPanel(sourceDirectoryRoot);
		JPanel progressPanel = createProgressPanel(progressMeter);
		JPanel consolePanel = createConsolePanel();

		JPanel panel = new JPanel();
		panel.setLayout(new BorderLayout());
		panel.add(this.directoryChooserPanel, BorderLayout.NORTH);
		panel.add(progressPanel, BorderLayout.CENTER);
		panel.add(consolePanel, BorderLayout.SOUTH);
		return panel;
	}

	private JPanel createConsolePanel(){
		this.startButton = new JButton("Start");
		this.stopButton = new JButton("Stop");

		progressBar = new SessionProgressBar(this.model);

		JPanel consolePanel = new JPanel();
		//statusField = new StatusField();
		//this.model.addObserver(statusField);
		//statusField.setPreferredSize(new Dimension(300, 16));
		//statusField.setSize(new Dimension(300, 16));
		consolePanel.setLayout(new BoxLayout(consolePanel, BoxLayout.Y_AXIS));
		JPanel consolePanelUpper = new JPanel();
		consolePanelUpper.setLayout(new BoxLayout(consolePanelUpper, BoxLayout.X_AXIS));
		consolePanelUpper.add(this.startButton);
		consolePanelUpper.add(this.stopButton);
		consolePanelUpper.add(Box.createHorizontalStrut(6));
		consolePanelUpper.add(progressBar);
		consolePanelUpper.add(Box.createHorizontalStrut(6));
		this.stopButton.setEnabled(false);
		consolePanel.add(consolePanelUpper);
		return consolePanel;
	}

	private SessionProgressMeter createProgressMeter() {
		SessionProgressMeter progressMeter = new SessionProgressMeter(this.model); 
		return progressMeter;
	}

	private JPanel createProgressPanel(SessionProgressMeter progressMeter) {
		JPanel progressPanel = new JPanel();
		progressPanel.setLayout(new BoxLayout(progressPanel, BoxLayout.Y_AXIS));
		progressPanel.add(progressMeter);
		progressPanel.add(Box.createVerticalStrut(10));
		progressPanel.setPreferredSize(new Dimension(150,150));
		return progressPanel;
	}

	private DirectoryChooserPanel createDirectoryChooserPanel(File sourceRootDirectoy) {
		final DirectoryChooserPanel directoryChooserPanel = new DirectoryChooserPanel(this);
		directoryChooserPanel.setFile(sourceRootDirectoy);
		directoryChooserPanel.setToolTipText("Drag and drop \"Source Directory\" here!");
		new FileDropTargetDecorator(this){
			public void drop(File file){
				if(directoryChooserPanel.getTextField().isEnabled() && file.isDirectory() && ! file.getName().endsWith("-RESULT")){
					directoryChooserPanel.getTextField().setText(file.getAbsolutePath());
					directoryChooserPanel.setFile(file);
				}
			}
		};
		return directoryChooserPanel;
	}

	void start() {
		this.progressBar.setIndeterminate(true);
		this.startButton.setEnabled(false);
		this.stopButton.setEnabled(true);
		this.directoryChooserPanel.setEnabled(false);
		this.menuBar.openMenuItem.setEnabled(false);
		this.setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
	}

	void stop(){
		this.progressBar.setIndeterminate(false);
		this.startButton.setEnabled(true);
		this.stopButton.setEnabled(false);
		this.directoryChooserPanel.setEnabled(true);
		this.menuBar.openMenuItem.setEnabled(true);
		this.setCursor(Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	}

	void exitConfirmation(){
		if(JOptionPane.showConfirmDialog(this, new String[]{"Really exit?"}, "Exit Confirmation", JOptionPane.OK_CANCEL_OPTION) == JOptionPane.OK_OPTION){
			try{
				this.launcher.exit();
			}catch(Exception ignore){
			}
		}
	}
}