/**
 *  EngineControlButtonPanel.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/29
 Author hiroya
 */
package net.sqs2.exigrid.swing;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class EngineControlButtonPanel extends JPanel {
	static private final long serialVersionUID = 0L;	

	JButton clearButton;
	JButton startButton;
	JButton stopButton;

	EngineControlButtonPanel(){
		setLayout(new BoxLayout(this, BoxLayout.X_AXIS));
		add(clearButton = createClearButton());
		add(startButton = createStartButton());
		add(stopButton = createStopButton());
	}

	JButton createClearButton(){
		JButton clearButton = new JButton("clear");
		clearButton.setToolTipText("clear previous result");
		return clearButton;
	}

	JButton createStartButton(){
		JButton startButton = new JButton("start");
		startButton.setToolTipText("start local session");
		return startButton;
	}

	JButton createStopButton(){
		JButton stopButton = new JButton("stop");
		stopButton.setToolTipText("stop local session");
		return stopButton;
	}

	public static void main(String[] args){
		JFrame frame = new JFrame();
		frame.add(new EngineControlButtonPanel());
		frame.pack();
		frame.setVisible(true);
	}
}
