/*

 PageTaskError.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/04/07

 */
package net.sqs2.exigrid.source;

import java.io.Serializable;


public class PageTaskError implements Serializable{
	private static final long serialVersionUID = 0L;
	String message;
	PageID source;
	byte[] srcImage;
	String srcImageType;
	double scale;
	PageTaskExceptionCore exceptionCore;

	public PageTaskError(String message){
		this.message = message;
	}

	public PageTaskError(PageID source, byte[] srcImage, String srcImageType, double scale, PageTaskExceptionCore exceptionCore){
		this.source = source;
		this.srcImage = srcImage;
		this.srcImageType = srcImageType;
		this.scale = scale;
		this.exceptionCore = exceptionCore;
	}

	public PageID getSource(){
		return this.source;
	}

	public byte[] getSourceImageByteArray(){
		return this.srcImage;
	}

	public String getSourceImageType(){
		return this.srcImageType;
	}

	public double getScale(){
		return this.scale; 
	}

	public String getDescription(){
		return this.exceptionCore.getDescription();
	}

	public PageTaskExceptionCore getExceptionCore(){
		return this.exceptionCore;
	}

	public String toString(){
		return getDescription();
	}
}
