/*
 * 

 PageTask.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.exigrid.source;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;



public interface PageTask extends Delayed{

	public abstract String getID();

	public abstract String getSourceDirectoryRootPath();

	public abstract String getMasterPath();

	public abstract long getMasterLastModified();

	public abstract int getPageNumber();

	public abstract PageID getPageID();

	public abstract String getPageTaskConfigPath();

	public abstract long getPageTaskConfigLastModified();

	public abstract PageTaskResult getPageTaskResult();

	public abstract void setResult(PageTaskResult resultData);

	public abstract long getOMRSessionID();

	public abstract String toString();

	public abstract boolean equals(Object o);

	public abstract void setLeased();

	public abstract long getDelay(TimeUnit unit);

	public abstract int compareTo(Delayed o);

	public abstract PageTaskError getPageTaskError();

	public abstract void setPageTaskError(PageTaskError pageTaskError);

	public abstract int hashCode();

}