/*

 PageID.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2005/12/27

 */
package net.sqs2.exigrid.source;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;

import net.sqs2.image.ImageFactory;
import net.sqs2.util.FileUtil;

public class PageID implements Serializable{
	private static final long serialVersionUID = 1L;

	private String path;
	private long lastModified;
	private int index;
	private int numPagesInFile;

	public PageID(){
	}

	public PageID(String path, long lastModified, int index, int numPagesInFile){
		this.path = path;
		this.index = index;
		this.numPagesInFile = numPagesInFile;
		this.lastModified = lastModified;
	}

	public String getPath() {
		return this.path;
	}

	public String getExtension(){
		return FileUtil.getSuffix(this.path);
	}

	public int getIndex() {
		return this.index;
	}

	public int getNumPagesInFile(){
		return this.numPagesInFile;
	}

	public long getLastModified() {
		return this.lastModified;
	}

	public int compareTo(Object o) {
		try{
			PageID pageID = (PageID)o;
			int diff = 0;
			if((diff = pageID.getIndex() - getIndex()) != 0){
				return diff;
			}
			if((diff = pageID.getPath().compareTo(this.path)) != 0){
				return diff;
			}
			return (int)(pageID.getLastModified() - this.lastModified);
		}catch(ClassCastException ex){
			return 1;
		}
	}
	
	@Override
	public boolean equals(Object o) {
		try{
			PageID pageID = (PageID)o;
			return (pageID.getIndex() == getIndex() &&
					pageID.getPath().equals(this.path) &&
					pageID.getLastModified() == this.lastModified);
		}catch(ClassCastException ex){
			return false;
		}
	}

	@Override
	public int hashCode(){
		return this.path.hashCode() ^ this.index ^ this.numPagesInFile ^ (int)(this.lastModified/Integer.MAX_VALUE); 
	}
	
	public String createID() {
		return createID(this.path, getLastModified(), this.index, this.numPagesInFile);
	}

	public static String createID(String path, long lastModified, int index, int numPagesInFile) {
		return path+"\t"+lastModified+"\t"+index+"\t"+numPagesInFile;
	}

	public BufferedImage createImage()throws IOException{
		String suffix = FileUtil.getSuffix(this.path);
		BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.path)); 
		return ImageFactory.createImage(in, this.index, suffix);
	}

}
