/*Session.java

 Copyright 2004-2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2005/11/11

 */
package net.sqs2.exigrid.session;

import java.io.IOException;

import net.sqs2.exigrid.event.ResultManagerMonitor;
import net.sqs2.exigrid.master.PageMasterFactory;
import net.sqs2.exigrid.source.PageTaskConfigFactory;
import net.sqs2.net.RMIRegistryMulticastAdvertisingService;

public class Session extends AbstractSession{
	
	public Session(
			PageMasterFactory pageMasterFactory,
			PageTaskConfigFactory pageTaskConfigFactory,
			ResultEventManagerFactory resultEventManagerFactory,
			long key,
			RMIRegistryMulticastAdvertisingService advertisingService, 
			String serviceName){
		super(pageMasterFactory, pageTaskConfigFactory, resultEventManagerFactory, key, advertisingService, serviceName);
	}
	
	public boolean execute() throws IOException{
		if(isNoPageTask() && ! this.isNowProducingPageTasks() && ! this.resultEventManager.isResultProducedTimeEqualsLastPageProcessedTime()){

			this.resultEventManager.execute();

			finishFanfare();

			for(ResultManagerMonitor monitor: this.monitors){
				monitor.notifyFinished();
			}
			return true;
		}
		return false;
	}

}
