/*

 PageTaskConsumer.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.

 Created on 2007/01/11

 */
package net.sqs2.exigrid.session;

import java.io.File;
import java.io.IOException;

import net.sqs2.exigrid.event.ResultEventManager;
import net.sqs2.exigrid.event.SessionMonitor;
import net.sqs2.exigrid.source.PageTask;
import net.sqs2.exigrid.source.PageTaskAccessor;
import net.sqs2.exigrid.source.PageTaskException;

public class PageTaskConsumer implements Runnable{

	private SessionMonitor monitor = null;
	private AbstractSession session;
	private PageTaskAccessor pageTaskAccessor;

	private ResultEventManager resultEventManager;

	PageTaskConsumer(AbstractSession session,
			File sourceDirectoryRoot, File resultDirectoryRoot,
			ResultEventManager resultEventManager)throws PageTaskException, IOException{
		this.session = session; 
		this.pageTaskAccessor = new PageTaskAccessor(sourceDirectoryRoot, resultDirectoryRoot);
		this.resultEventManager = resultEventManager;
	}

	public void setMonitor(SessionMonitor monitor){
		this.monitor = monitor;
	}

	public void run(){
		try{
			PageTask pageTask = this.session.getPageTaskHolder().pollSubmittedPageTask();
			if(pageTask != null){
				if(pageTask.getPageTaskError() == null){
					this.session.getPageTaskHolder().incrementNumExternalizedPages();
				}else{
					this.session.getPageTaskHolder().incrementNumErrorPages(pageTask);
				}
				storePageTask(pageTask);
				this.monitor.notifyConsumePageTask(pageTask);
				this.resultEventManager.notifyPageTaskReceived(pageTask);
			}else{
				this.session.execute();
				return;
			}
		}catch(Exception ex){
			ex.printStackTrace();
		}
	}

	private void storePageTask(PageTask pageTask) {
		try{
			this.pageTaskAccessor.put(pageTask);
			this.pageTaskAccessor.flush();
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
	}
}
