/*
 * 

 PageMaster.java

 Copyright 2007 KUBO Hiroya (hiroya@cuc.ac.jp).

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
package net.sqs2.exigrid.master;

import java.awt.Point;
import java.io.Serializable;

import net.sqs2.util.FileResource;

public class PageMaster implements Serializable{
	private final static long serialVersionUID = 3L; 

	protected int masterIndex;
	protected FileResource fileResource = null;
	protected int numPages;
	protected Point[] corners = null;

	public PageMaster() {
		super();
	}

	public PageMaster(int masterIndex, FileResource fileResource) {
		this.masterIndex = masterIndex;
		this.fileResource = fileResource;
	}

    public int getMasterIndex(){
    	return this.masterIndex;
    }
    
	public FileResource getFileResource() {
		return this.fileResource;
	}

	public Point[] getCorners() {
		return this.corners;
	}

	public void setCorners(Point[] corners) {
		this.corners = corners;
	}

	public int getNumPages() {
		return this.numPages;
	}

	public void setNumPages(int numPages) {
		this.numPages = numPages;
	}

	public String getPath() {
		return this.fileResource.getPath();
	}

	public long getLastModified() {
		return this.fileResource.getLastModified();
	}

	public FileResource getPathWithLastModified(){
		return this.fileResource;
	}

	@Override
	public String toString() {
		return getPath();
	}

	@Override
	public boolean equals(Object o){
		if(o == null){
			return false;
		}
		return this.fileResource.equals(((PageMaster)o).getFileResource());
	}

	@Override
	public int hashCode(){
		return this.fileResource.hashCode();
	}

}