/**
 * 
 */
package net.sqs2.exigrid.execute;

import java.rmi.RemoteException;

import net.sqs2.exigrid.source.PageTask;
import net.sqs2.exigrid.source.PageTaskConfig;

public class SessionExecutorTask{

	private PageTask pageTask;
	private SessionExecutorResource sessionExecutorResource;

	SessionExecutorTask(PageTask pageTask, SessionExecutorResource sessionResource){
		this.pageTask = pageTask;
		this.sessionExecutorResource = sessionResource;
	}

	public PageTask getPageTask(){
		return pageTask;
	}

	public PageTaskConfig getPageTaskConfig()throws RemoteException{
		return this.sessionExecutorResource.getPageTaskConfig(pageTask.getPageTaskConfigPath(), pageTask.getPageTaskConfigLastModified());
	}

	public SessionExecutorResource getSessionExecutorResource(){
		return this.sessionExecutorResource;
	}

	public void close(){
		this.sessionExecutorResource.close();
		this.sessionExecutorResource = null;
	}
}